/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.codec.http.HttpExchangeMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.SimpleHttpResponseMessage;
import org.jetlinks.demo.protocol.TopicMessageCodec;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class HttpDeviceMessageCodec
extends TopicMessageCodec
implements DeviceMessageCodec {
    public Transport getSupportTransport() {
        return DefaultTransport.HTTP;
    }

    public Mono<? extends Message> decode(MessageDecodeContext context) {
        return Mono.defer(() -> {
            HttpExchangeMessage mqttMessage = (HttpExchangeMessage)context.getMessage();
            String topic = mqttMessage.getUrl();
            JSONObject payload = JSON.parseObject((String)mqttMessage.getPayload().toString(StandardCharsets.UTF_8));
            return Mono.justOrEmpty((Object)this.doDecode(null, topic, payload)).switchIfEmpty(Mono.defer(() -> mqttMessage.response((HttpResponseMessage)SimpleHttpResponseMessage.builder().status(404).contentType(MediaType.APPLICATION_JSON).payload(Unpooled.wrappedBuffer((byte[])"{\"success\":false}".getBytes())).build()).then(Mono.empty()))).flatMap(msg -> mqttMessage.response((HttpResponseMessage)SimpleHttpResponseMessage.builder().status(200).contentType(MediaType.APPLICATION_JSON).payload(Unpooled.wrappedBuffer((byte[])"{\"success\":true}".getBytes())).build()).thenReturn(msg));
        });
    }

    public Mono<EncodedMessage> encode(MessageEncodeContext context) {
        return Mono.empty();
    }
}

