/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.demo.protocol.coap;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import org.eclipse.californium.core.coap.CoAP;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.codec.CoapExchangeMessage;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.DeviceMessageCodec;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageDecodeContext;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.demo.protocol.TopicMessageCodec;
import reactor.core.publisher.Mono;

public class CoAPDeviceMessageCodec
extends TopicMessageCodec
implements DeviceMessageCodec {
    public Transport getSupportTransport() {
        return DefaultTransport.CoAP;
    }

    public Mono<? extends Message> decode(MessageDecodeContext context) {
        return Mono.defer(() -> {
            CoapExchangeMessage message = (CoapExchangeMessage)context.getMessage();
            String topic = message.getPath();
            if (!topic.startsWith("/")) {
                topic = "/".concat(topic);
            }
            JSONObject payload = JSON.parseObject((String)message.getPayload().toString(StandardCharsets.UTF_8));
            return Mono.justOrEmpty((Object)this.doDecode(null, topic, payload)).doOnSuccess(msg -> {
                if (msg == null) {
                    message.getExchange().respond("success");
                } else {
                    message.getExchange().respond(CoAP.ResponseCode.NOT_FOUND);
                }
            });
        });
    }

    public Mono<EncodedMessage> encode(MessageEncodeContext context) {
        return Mono.empty();
    }
}

