/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr;

import com.oracle.jrockit.jfr.management.NoSuchRecordingException;
import java.io.IOException;
import javax.management.ObjectName;
import oracle.jrockit.jfr.DCmd;
import oracle.jrockit.jfr.DCmdException;
import oracle.jrockit.jfr.Recording;
import oracle.jrockit.jfr.VMJFR;

final class DCmdDump
extends DCmd {
    DCmdDump(VMJFR vMJFR) {
        super(vMJFR);
    }

    public void execute(String string, long l, String string2, boolean bl) throws DCmdException {
        DCmd.RecordingIdentifier recordingIdentifier = DCmd.RecordingIdentifier.createValid(string, l);
        if (string2 == null) {
            throw new DCmdException("Failed to dump %s, missing filename.", recordingIdentifier);
        }
        Recording recording = this.findRecording(recordingIdentifier);
        String string3 = string + "_copy_" + System.nanoTime();
        ObjectName objectName = null;
        try {
            objectName = this.jfrMBean.cloneRecording(recording, string3, true);
            Recording recording2 = this.jfrMBean.getRecording(objectName);
            this.print("Dumped %s, ", recordingIdentifier);
            this.writeToDisk(recording2, string2, bl, recordingIdentifier);
        }
        catch (NoSuchRecordingException | IOException exception) {
            throw new DCmdException("Failed to dump %s. Could not clone temporary recording for dump.", recordingIdentifier);
        }
        finally {
            if (objectName != null) {
                try {
                    this.jfrMBean.close(objectName);
                }
                catch (NoSuchRecordingException noSuchRecordingException) {}
            }
        }
    }
}

