/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.ImageToolkit;
import java.util.Arrays;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDescriptor base;
    private final boolean reduceAlpha;
    private final ImageDescriptor[] overlays;

    public OverlayImageDescriptor(ImageDescriptor base, boolean reduceAlpha, ImageDescriptor ... overlays) {
        this.base = base;
        this.overlays = overlays;
        this.reduceAlpha = reduceAlpha;
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData id = this.base.getImageData();
        if (this.reduceAlpha) {
            ImageToolkit.adjustAlphaLevel(id, 2);
        }
        this.drawImage(id, 0, 0);
        ImageDescriptor[] imageDescriptorArray = this.overlays;
        int n = this.overlays.length;
        int n2 = 0;
        while (n2 < n) {
            ImageDescriptor overlay = imageDescriptorArray[n2];
            if (overlay != null) {
                this.drawImage(overlay.getImageData(), 0, 0);
            }
            ++n2;
        }
    }

    protected Point getSize() {
        ImageData baseData = this.base.getImageData();
        return new Point(baseData.width, baseData.height);
    }

    public int hashCode() {
        return this.base.hashCode() + Arrays.hashCode(this.overlays);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OverlayImageDescriptor)) {
            return false;
        }
        OverlayImageDescriptor other = (OverlayImageDescriptor)((Object)obj);
        return other.reduceAlpha == this.reduceAlpha && other.base.equals(this.base) && Arrays.equals(other.overlays, this.overlays);
    }
}

