/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.prefs.PreferenceInitializer;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProvSDKUIActivator
extends AbstractUIPlugin {
    private static ProvSDKUIActivator plugin;
    private static BundleContext context;
    private ScopedPreferenceStore preferenceStore;
    private IPropertyChangeListener preferenceListener;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui.sdk";

    public static BundleContext getContext() {
        return context;
    }

    public static ProvSDKUIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ProvSDKUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        PreferenceInitializer.migratePreferences();
        this.getPreferenceStore().addPropertyChangeListener(this.getPreferenceListener());
    }

    private IPropertyChangeListener getPreferenceListener() {
        if (this.preferenceListener == null) {
            this.preferenceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ProvSDKUIActivator.this.updateWithPreferences(ProvSDKUIActivator.this.getPolicy());
                }
            };
        }
        return this.preferenceListener;
    }

    public ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    Policy getPolicy() {
        return this.getProvisioningUI().getPolicy();
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.getProvisioningUI().getSession().getProvisioningAgent();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        this.getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        super.stop(bundleContext);
    }

    static IStatus getNoSelfProfileStatus() {
        return new Status(2, PLUGIN_ID, ProvSDKMessages.ProvSDKUIActivator_NoSelfProfile);
    }

    void updateWithPreferences(Policy policy) {
        IPreferenceStore store = this.getPreferenceStore();
        String value = store.getString("showLatestVersion");
        policy.setShowLatestVersionsOnly(!"".equals(value) ? store.getBoolean("showLatestVersion") : policy.getShowLatestVersionsOnly());
        value = store.getString("hideAlreadyInstalled");
        policy.setHideAlreadyInstalled(!"".equals(value) ? store.getBoolean("hideAlreadyInstalled") : policy.getHideAlreadyInstalled());
        value = store.getString("filterOnEnv");
        policy.setFilterOnEnv(!"".equals(value) ? store.getBoolean("filterOnEnv") : policy.getFilterOnEnv());
        value = store.getString("contactAllSites");
        policy.setContactAllSites(!"".equals(value) ? store.getBoolean("contactAllSites") : policy.getContactAllSites());
        value = store.getString("groupByCategory");
        policy.setGroupByCategory(!"".equals(value) ? store.getBoolean("groupByCategory") : policy.getGroupByCategory());
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            IAgentLocation agentLocation = this.getAgentLocation();
            if (agentLocation == null) {
                return super.getPreferenceStore();
            }
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProfileScope(agentLocation, "_SELF_"), PLUGIN_ID);
        }
        return this.preferenceStore;
    }

    private IAgentLocation getAgentLocation() {
        ServiceReference ref = ProvSDKUIActivator.getContext().getServiceReference(IAgentLocation.SERVICE_NAME);
        if (ref == null) {
            return null;
        }
        IAgentLocation location = (IAgentLocation)ProvSDKUIActivator.getContext().getService(ref);
        ProvSDKUIActivator.getContext().ungetService(ref);
        return location;
    }

    public void savePreferences() {
        if (this.preferenceStore != null) {
            try {
                this.preferenceStore.save();
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, 0, ProvSDKMessages.ProvSDKUIActivator_ErrorSavingPrefs, (Throwable)e), 3);
            }
        }
    }
}

