/*
 * Decompiled with CFR 0.152.
 */
package org.openide.options;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextProxy;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.options.SystemOption;
import org.openide.util.io.NbMarshalledObject;

public abstract class ContextSystemOption
extends SystemOption
implements BeanContextProxy {
    private static Object ctxt = new Object();
    private static final long serialVersionUID = -781528552645947127L;
    protected BeanContext beanContext = this.getBeanContext();

    public final void addOption(SystemOption systemOption) {
        this.getBeanContext().add(systemOption);
    }

    public final void removeOption(SystemOption systemOption) {
        this.getBeanContext().remove((Object)systemOption);
    }

    public final SystemOption[] getOptions() {
        Object[] objectArray = this.getBeanContext().toArray();
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof SystemOption)) continue;
            if (i > n) {
                objectArray[n] = objectArray[i];
            }
            ++n;
        }
        SystemOption[] systemOptionArray = new SystemOption[n];
        System.arraycopy(objectArray, 0, systemOptionArray, 0, n);
        return systemOptionArray;
    }

    @Override
    public final BeanContextChild getBeanContextProxy() {
        return this.getBeanContext();
    }

    private BeanContext getBeanContext() {
        return (BeanContext)this.getProperty(ctxt);
    }

    protected void initialize() {
        super.initialize();
        this.putProperty(ctxt, new OptionBeanContext(this));
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        Object[] objectArray = this.getBeanContext().toArray();
        Arrays.sort(objectArray, new ClassComparator());
        for (int i = 0; i < objectArray.length; ++i) {
            objectOutput.writeObject(new NbMarshalledObject(objectArray[i]));
        }
        objectOutput.writeObject(null);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof BeanContext) {
            this.beanContext = (BeanContext)object;
        } else {
            BeanContext beanContext = this.getBeanContext();
            while (object != null) {
                NbMarshalledObject nbMarshalledObject = (NbMarshalledObject)object;
                try {
                    beanContext.add(nbMarshalledObject.get());
                }
                catch (Exception exception) {
                    Logger.getLogger(ContextSystemOption.class.getName()).log(Level.WARNING, null, exception);
                }
                catch (LinkageError linkageError) {
                    Logger.getLogger(ContextSystemOption.class.getName()).log(Level.WARNING, null, linkageError);
                }
                object = objectInput.readObject();
            }
        }
    }

    private static class OptionBeanContext
    extends BeanContextSupport
    implements PropertyChangeListener {
        private static final long serialVersionUID = 3532434266136225440L;
        private ContextSystemOption parent = null;

        public OptionBeanContext(ContextSystemOption contextSystemOption) {
            this.parent = contextSystemOption;
        }

        @Override
        public boolean add(Object object) {
            if (!(object instanceof SystemOption)) {
                throw new IllegalArgumentException("Not a SystemOption: " + object);
            }
            boolean bl = super.add(object);
            if (bl) {
                ((SystemOption)((Object)object)).addPropertyChangeListener(this);
            }
            return bl;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof SystemOption)) {
                throw new IllegalArgumentException("Not a SystemOption: " + object);
            }
            boolean bl = super.remove(object);
            if (bl) {
                ((SystemOption)((Object)object)).removePropertyChangeListener(this);
            }
            return bl;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.parent != null) {
                this.parent.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class ClassComparator
    implements Comparator {
        ClassComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.getClass().getName().compareTo(object2.getClass().getName());
        }
    }
}

