/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.service.IBusPatientService;
import com.tuoren.web.layer.vo.PatientParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BusPatientController"}, description="\u75c5\u4eba\u4fe1\u606f\u7ba1\u7406")
@RestController
@RequestMapping(value={"/bus/patient"})
public class BusPatientController {
    private static final Logger log = LoggerFactory.getLogger(BusPatientController.class);
    @Autowired
    public IBusPatientService iBusPatientEntityService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, BusPatientEntity busPatientEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper((Object)busPatientEntity);
        wrapper.orderByDesc((Object)"gmt_modified");
        return CommonResult.success((Object)this.iBusPatientEntityService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iBusPatientEntityService.getById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public CommonResult insert(@RequestBody BusPatientEntity busPatientEntity) {
        try {
            return CommonResult.success((Object)this.iBusPatientEntityService.save(busPatientEntity), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody BusPatientEntity busPatientEntity) {
        try {
            return CommonResult.success((Object)this.iBusPatientEntityService.updateById(busPatientEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.success((Object)this.iBusPatientEntityService.removeByIds(idList), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u75c5\u4eba \u4f4f\u9662\u53f7 patientCode | \u6cf5\u53f7 pumpCode | \u4ea7\u54c1\u7f16\u7801\u7c7b\u578b productCode | \u533b\u9662 hospitalCode | \u4eba\u540d name  | \u75c5\u533a\u53f7 wardCode | \u5e8a\u53f7 bedCode ")
    @PostMapping(value={"/getFuzzyPatient"})
    public CommonResult getFuzzyPatient(@RequestBody PatientParam patientParam) {
        try {
            IPage<BusPatientEntity> iPage = this.iBusPatientEntityService.queryFuzzyPatient(patientParam);
            if (iPage.getRecords().size() > 0) {
                return CommonResult.success(iPage);
            }
            return CommonResult.noData();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }
}

