/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.entity.BusReceiveRecordEntity;
import com.tuoren.web.layer.service.IBusPatientService;
import com.tuoren.web.layer.service.IBusReceiveRecordCopyService;
import com.tuoren.web.layer.service.IBusReceiveRecordService;
import com.tuoren.web.layer.vo.BusReceiveRecordCopyParam;
import com.tuoren.web.layer.vo.ReceiveRecordParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BusReceiveRecordController"}, description="\u5386\u53f2\u8bb0\u5f55\u7ba1\u7406")
@RestController
@RequestMapping(value={"/bus/receive-record"})
public class BusReceiveRecordController {
    private static final Logger log = LoggerFactory.getLogger(BusReceiveRecordController.class);
    @Autowired
    public IBusReceiveRecordService iBusReceiveRecordEntityService;
    @Autowired
    public IBusReceiveRecordCopyService iBusReceiveRecordEntityCopyService;
    @Autowired
    public IBusPatientService iBusPatientService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="viewState", required=false) String viewState, BusReceiveRecordEntity busReceiveRecordEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper((Object)busReceiveRecordEntity).like(StrUtil.isNotBlank((CharSequence)viewState), BusReceiveRecordEntity::getViewState, (Object)viewState)).orderByDesc(BusReceiveRecordEntity::getLastUploadTime);
        return CommonResult.success((Object)this.iBusReceiveRecordEntityService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e(\u6a21\u7cca\u67e5\u8be2)")
    @PostMapping(value={"/list"})
    public CommonResult<IPage<BusReceiveRecordCopyParam>> selectCopyAll(Integer pageNo, Integer pageSize, @RequestBody BusReceiveRecordCopyParam busReceiveRecordCopyParam) {
        IPage<BusReceiveRecordCopyParam> result = this.iBusReceiveRecordEntityCopyService.selectCopyAll(pageNo, pageSize, busReceiveRecordCopyParam);
        return CommonResult.success(result);
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iBusReceiveRecordEntityService.getById(id));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/query/{id}"})
    public CommonResult<BusReceiveRecordCopyParam> selectCopyOne(@PathVariable(value="id") String id) {
        System.out.println(this.iBusReceiveRecordEntityCopyService.selectCopyById(id));
        return CommonResult.success((Object)this.iBusReceiveRecordEntityCopyService.selectCopyById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public CommonResult insert(@RequestBody BusReceiveRecordEntity busReceiveRecordEntity) {
        try {
            return CommonResult.success((Object)this.iBusReceiveRecordEntityService.save(busReceiveRecordEntity), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody BusReceiveRecordEntity busReceiveRecordEntity) {
        try {
            return CommonResult.success((Object)this.iBusReceiveRecordEntityService.updateById(busReceiveRecordEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.success((Object)this.iBusReceiveRecordEntityService.removeByIds(idList), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6839\u636e\u6cf5\u53f7\u3001\u75c5\u4ebaID\u3001\u4f4f\u9662\u53f7\u83b7\u53d6\u5386\u53f2\u62a5\u8b66\u4fe1\u606f")
    @PostMapping(value={"/selectRevRecordByPatient"})
    public CommonResult selectScoreByPatient(@RequestBody ReceiveRecordParam receiveRecordParam) {
        QueryWrapper pie = new QueryWrapper();
        pie.eq(StrUtil.isNotBlank((CharSequence)receiveRecordParam.getPatientId()), (Object)"patient_id", (Object)receiveRecordParam.getPatientId());
        BusPatientEntity patientInfoEntity = (BusPatientEntity)this.iBusPatientService.getOne((Wrapper)pie);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)receiveRecordParam.getPumpCode()), (Object)"pump_code", (Object)receiveRecordParam.getPumpCode());
        wrapper.eq((Object)"patient_code", (Object)patientInfoEntity.getPatientCode());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)receiveRecordParam.getHospitalCode()), (Object)"hospital_code", (Object)receiveRecordParam.getHospitalCode());
        wrapper.and(w -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)w.eq((Object)"state_flag", (Object)4)).or()).eq((Object)"buf_state9", (Object)1);
        });
        wrapper.orderByDesc((Object)"last_upload_time");
        wrapper.select(new String[]{" *"});
        wrapper.last("limit 15");
        List list = this.iBusReceiveRecordEntityService.list((Wrapper)wrapper);
        if (list.size() == 0) {
            return CommonResult.noData();
        }
        return CommonResult.success((Object)list);
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8bb0\u5f55 \u4f4f\u9662\u53f7 patientCode | \u6cf5\u53f7 pumpCode | \u4ea7\u54c1\u7f16\u7801\u7c7b\u578b productCode | \u533b\u9662 hospitalCode | \u72b6\u6001\u4fe1\u606f viewState")
    @PostMapping(value={"/getFuzzyHistory"})
    public CommonResult getFuzzyHistory(@RequestBody ReceiveRecordParam receiveRecordParam) {
        try {
            IPage<BusReceiveRecordEntity> iPage = this.iBusReceiveRecordEntityService.queryFuzzyHistory(receiveRecordParam);
            if (iPage.getRecords().size() > 0) {
                return CommonResult.success(iPage);
            }
            return CommonResult.noData();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }
}

