/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.mapper.handler;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@MappedTypes(value={List.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
@Component
public class ListTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(ListTypeHandler.class);
    private Class<T> type;

    public ListTypeHandler() {
    }

    public ListTypeHandler(Class<T> type) {
        if (log.isTraceEnabled()) {
            log.trace("ListTypeHandler(" + type + ")");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type argument cannot be null");
        }
        this.type = type;
    }

    private T parse(String json) {
        if (json == null || json.length() == 0) {
            return null;
        }
        JSONArray objects = JSONUtil.parseArray((String)json);
        return (T)objects.toList(String.class);
    }

    private String toJsonString(Object obj) {
        return JSONUtil.parseArray((Object)obj).toString();
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.parse(rs.getString(columnName));
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.parse(rs.getString(columnIndex));
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.parse(cs.getString(columnIndex));
    }

    public void setNonNullParameter(PreparedStatement ps, int columnIndex, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(columnIndex, this.toJsonString(parameter));
    }
}

