/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tuoren.common.redis.RedisService;
import com.tuoren.web.layer.entity.SysBlackListEntity;
import com.tuoren.web.layer.mapper.SysBlackListMapper;
import com.tuoren.web.layer.service.ISysBlackListService;
import com.tuoren.web.netty.enums.BanLevelType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysBlackListServiceImpl
extends ServiceImpl<SysBlackListMapper, SysBlackListEntity>
implements ISysBlackListService {
    @Autowired
    RedisService redisService;
    @Autowired
    SysBlackListMapper sysBlackListMapper;

    @Override
    public boolean save(SysBlackListEntity entity) {
        String key = "black:list:temporary:" + entity.getIpAddress();
        String jsonString = null;
        QueryWrapper blackListQueryWrapper = new QueryWrapper();
        blackListQueryWrapper.eq((Object)"ip_address", (Object)entity.getIpAddress());
        SysBlackListEntity result = (SysBlackListEntity)this.sysBlackListMapper.selectOne((Wrapper)blackListQueryWrapper);
        if (result == null) {
            entity.setBanLevel(BanLevelType.getInit().getLevel());
            jsonString = JSON.toJSONString((Object)entity);
            this.sysBlackListMapper.insert(entity);
            this.redisService.setAndExpire(key, jsonString, BanLevelType.getMicros(entity.getBanLevel()));
        } else {
            int banLevel = result.getBanLevel();
            banLevel = banLevel == BanLevelType.getTop().getLevel() ? banLevel : banLevel + 1;
            entity.setBanLevel(banLevel);
            jsonString = JSON.toJSONString((Object)entity);
            this.sysBlackListMapper.update(entity, (Wrapper)blackListQueryWrapper);
            if (entity.getBanLevel() == BanLevelType.getTop().getLevel()) {
                key = "black:list:permanent:" + entity.getIpAddress();
                this.redisService.set(key, jsonString);
            } else {
                this.redisService.setAndExpire(key, jsonString, BanLevelType.getMicros(entity.getBanLevel()));
            }
        }
        return true;
    }

    @Override
    public SysBlackListEntity selectByIp(String ip) {
        String key = null;
        String jsonString = null;
        key = "black:list:temporary:" + ip;
        jsonString = this.redisService.get(key);
        if (jsonString == null) {
            key = "black:list:permanent:" + ip;
            jsonString = this.redisService.get(key);
        }
        SysBlackListEntity sysBlackListEntity = (SysBlackListEntity)JSON.parseObject((String)jsonString, SysBlackListEntity.class);
        return sysBlackListEntity;
    }

    @Override
    public void delete(SysBlackListEntity entity) {
        String key = "black:list:temporary:" + entity.getIpAddress();
        if (entity.getBanLevel() == BanLevelType.getTop().getLevel()) {
            key = "black:list:permanent:" + entity.getIpAddress();
        }
        QueryWrapper blackListQueryWrapper = new QueryWrapper();
        blackListQueryWrapper.eq((Object)"ip_address", (Object)entity.getIpAddress());
        this.sysBlackListMapper.delete((Wrapper)blackListQueryWrapper);
        this.redisService.remove(key);
    }

    @Override
    public List<SysBlackListEntity> selectAll() {
        QueryWrapper blackListQueryWrapper = new QueryWrapper();
        blackListQueryWrapper.ne(false, (Object)"ip_address", null);
        List sysBlackListEntities = this.sysBlackListMapper.selectList((Wrapper)blackListQueryWrapper);
        return sysBlackListEntities;
    }

    @Override
    public boolean removeByIds(List<Long> idList) {
        List sysBlackListEntities = this.sysBlackListMapper.selectBatchIds(idList);
        this.sysBlackListMapper.deleteBatchIds(idList);
        ArrayList keys = new ArrayList();
        sysBlackListEntities.forEach(sysBlackListEntity -> {
            if (sysBlackListEntity.getBanLevel() != BanLevelType.getTop().getLevel()) {
                keys.add("black:list:temporary:" + sysBlackListEntity.getIpAddress());
            } else {
                keys.add("black:list:permanent:" + sysBlackListEntity.getIpAddress());
            }
        });
        this.redisService.remove(keys);
        return true;
    }

    public boolean updateById(SysBlackListEntity newSysBlackListEntity) {
        Long id = newSysBlackListEntity.getId();
        String jsonString = JSON.toJSONString((Object)newSysBlackListEntity);
        SysBlackListEntity oldSysBlackListEntity = (SysBlackListEntity)this.sysBlackListMapper.selectById(newSysBlackListEntity.getId());
        this.sysBlackListMapper.updateById(newSysBlackListEntity);
        String key = "black:list:temporary:" + oldSysBlackListEntity.getIpAddress();
        if (oldSysBlackListEntity.getBanLevel() == BanLevelType.getTop().getLevel()) {
            key = "black:list:permanent:" + oldSysBlackListEntity.getIpAddress();
        }
        this.redisService.remove(key);
        key = "black:list:temporary:" + oldSysBlackListEntity.getIpAddress();
        if (newSysBlackListEntity.getBanLevel() == BanLevelType.getTop().getLevel()) {
            key = "black:list:permanent:" + newSysBlackListEntity.getIpAddress();
            this.redisService.set(key, jsonString);
        } else {
            this.redisService.setAndExpire(key, jsonString, BanLevelType.getMicros(newSysBlackListEntity.getBanLevel()));
        }
        return true;
    }
}

