/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.netty.blackList;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.tuoren.common.redis.RedisService;
import com.tuoren.web.layer.entity.SysBlackListEntity;
import com.tuoren.web.layer.service.ISysBlackListService;
import com.tuoren.web.netty.enums.BanLevelType;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SysBlackListConfig {
    @Autowired
    ISysBlackListService sysBlackListService;
    @Autowired
    RedisService redisService;

    @PostConstruct
    public void init() {
        List<SysBlackListEntity> sysBlackListEntities = this.sysBlackListService.selectAll();
        Set keys = this.redisService.getKeys("black*");
        sysBlackListEntities.forEach(entity -> {
            String key = "black:list:temporary:" + entity.getIpAddress();
            if (keys.contains(key)) {
                return;
            }
            String jsonString = JSON.toJSONString((Object)entity);
            if (entity.getBanLevel() == BanLevelType.T3.getLevel()) {
                key = "black:list:permanent:" + entity.getIpAddress();
                this.redisService.set(key, jsonString);
            } else {
                DateTime beginTime = DateUtil.parse((String)entity.getGmtCreate());
                long banMicros = BanLevelType.getMicros(entity.getBanLevel());
                long betweenTime = beginTime.between(new Date(), DateUnit.MS);
                if (betweenTime >= banMicros) {
                    return;
                }
                this.redisService.setAndExpire(key, jsonString, banMicros - betweenTime);
            }
        });
    }

    public ISysBlackListService getSysBlackListService() {
        return this.sysBlackListService;
    }

    public RedisService getRedisService() {
        return this.redisService;
    }

    public void setSysBlackListService(ISysBlackListService sysBlackListService) {
        this.sysBlackListService = sysBlackListService;
    }

    public void setRedisService(RedisService redisService) {
        this.redisService = redisService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysBlackListConfig)) {
            return false;
        }
        SysBlackListConfig other = (SysBlackListConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ISysBlackListService this$sysBlackListService = this.getSysBlackListService();
        ISysBlackListService other$sysBlackListService = other.getSysBlackListService();
        if (this$sysBlackListService == null ? other$sysBlackListService != null : !this$sysBlackListService.equals(other$sysBlackListService)) {
            return false;
        }
        RedisService this$redisService = this.getRedisService();
        RedisService other$redisService = other.getRedisService();
        return !(this$redisService == null ? other$redisService != null : !this$redisService.equals(other$redisService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysBlackListConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ISysBlackListService $sysBlackListService = this.getSysBlackListService();
        result = result * 59 + ($sysBlackListService == null ? 43 : $sysBlackListService.hashCode());
        RedisService $redisService = this.getRedisService();
        result = result * 59 + ($redisService == null ? 43 : $redisService.hashCode());
        return result;
    }

    public String toString() {
        return "SysBlackListConfig(sysBlackListService=" + this.getSysBlackListService() + ", redisService=" + this.getRedisService() + ")";
    }
}

