/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.netty.enums;

import java.util.concurrent.TimeUnit;

public enum BanLevelType {
    T0(0, TimeUnit.DAYS.toSeconds(1L)),
    T1(1, TimeUnit.DAYS.toSeconds(7L)),
    T2(2, TimeUnit.DAYS.toSeconds(30L)),
    T3(3, -1L);

    private int level;
    private long time;

    private BanLevelType(int level, long time) {
        this.level = level;
        this.time = time;
    }

    public int getLevel() {
        return this.level;
    }

    public long getTime() {
        return this.time;
    }

    public static long getMicros(int level) {
        long result = -1L;
        switch (level) {
            case 0: {
                result = T0.getTime();
                break;
            }
            case 1: {
                result = T1.getTime();
                break;
            }
            case 2: {
                result = T2.getTime();
                break;
            }
        }
        return result;
    }

    public static BanLevelType getTop() {
        return T3;
    }

    public static BanLevelType getInit() {
        return T0;
    }
}

