/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.netty.handler;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.tuoren.web.netty.blackList.SysBlackList;
import com.tuoren.web.netty.enums.BanType;
import com.tuoren.web.netty.param.PipeLineDO;
import com.tuoren.web.utils.NettyUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.SocketAddress;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ConcurrentReferenceHashMap;

public class TailHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(TailHandler.class);
    private static ConcurrentReferenceHashMap<String, AtomicInteger> ipMap = new ConcurrentReferenceHashMap();
    private static ConcurrentHashMap<String, AtomicBoolean> connectMap = new ConcurrentHashMap();

    public void channelActive(ChannelHandlerContext ctx) {
        PipeLineDO pipeLineDO = (PipeLineDO)NettyUtils.getAttribute(ctx.channel());
        if (connectMap.get(pipeLineDO.getIpAddress()) == null) {
            connectMap.put(pipeLineDO.getIpAddress(), new AtomicBoolean());
        }
        if (this.inValidate(pipeLineDO.getIpAddress())) {
            pipeLineDO.setExceedConnect(true);
            pipeLineDO.setScore(pipeLineDO.getScore() + (long)BanType.TooManyConnection.getScore());
            pipeLineDO.getBanCauses().add(this.getCause(BanType.TooManyConnection));
            AtomicBoolean aBoolean = connectMap.get(pipeLineDO.getIpAddress());
            if (!aBoolean.get() && aBoolean.compareAndSet(false, true) && this.isBan(pipeLineDO)) {
                ctx.channel().close();
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        PipeLineDO pipeLineDO = (PipeLineDO)NettyUtils.getAttribute(ctx.channel());
        Date startTime = pipeLineDO.getStartTime();
        if (DateUtil.between((Date)startTime, (Date)new Date(), (DateUnit)DateUnit.MINUTE) > 10L) {
            pipeLineDO.setScore(pipeLineDO.getScore() + (long)BanType.LongAlive.getScore());
            pipeLineDO.getBanCauses().add(BanType.LongAlive.getName());
        }
        if (this.isBan(pipeLineDO)) {
            ctx.channel().close();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        SocketAddress socketAddress = ctx.channel().remoteAddress();
        String[] split = socketAddress.toString().split(":");
        String ipAddress = split[0].substring(1);
        AtomicInteger channelCount = (AtomicInteger)ipMap.get((Object)ipAddress);
        if (channelCount != null) {
            if (channelCount.get() == 0) {
                ipMap.remove((Object)ipAddress);
            } else {
                channelCount.getAndDecrement();
            }
        }
        super.channelInactive(ctx);
    }

    private boolean isBan(PipeLineDO pipeLineDO) {
        long score = pipeLineDO.getScore();
        if (score >= 12L) {
            log.warn("\u6b64ip{}\u5df2\u52a0\u5165\u5230\u9ed1\u540d\u5355\u4e2d,\u539f\u56e0\u4e3a{}", (Object)pipeLineDO.getIpAddress(), (Object)pipeLineDO.getBanCauses().toString());
            pipeLineDO.setBan(true);
            SysBlackList.save(pipeLineDO);
            return true;
        }
        return false;
    }

    private boolean inValidate(String remoteIp) {
        AtomicInteger channelCount = (AtomicInteger)ipMap.get((Object)remoteIp);
        if (channelCount == null) {
            channelCount = new AtomicInteger(0);
            ipMap.put((Object)remoteIp, (Object)channelCount);
        }
        channelCount.getAndIncrement();
        return (long)channelCount.get() >= 12L;
    }

    private String getCause(BanType banType) {
        return DateUtil.now() + ":" + banType.getName();
    }
}

