/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.utils.listener.lmpl;

import com.tuoren.web.utils.listener.AbstractListener;
import com.tuoren.web.utils.listener.ListenerProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="file", name={"listenerTime"}, matchIfMissing=false)
@EnableConfigurationProperties(value={ListenerProperties.class})
public class ConverterContextListener
extends AbstractListener {
    private static final Logger log = LoggerFactory.getLogger(ConverterContextListener.class);
    @Autowired
    ListenerProperties listenerProperties;

    @PostConstruct
    public void init() {
        this.initProperties();
    }

    public void initProperties() {
        if (file.exists()) {
            File[] files;
            for (File file1 : files = file.listFiles()) {
                if (!file1.isFile() || !file1.getName().endsWith(".properties")) continue;
                String name = file1.getName();
                String[] split = name.split("\\.");
                Properties pp = new Properties();
                try {
                    pp.load(new BufferedReader(new InputStreamReader(new FileInputStream(file1))));
                    properties.put(split[0].toLowerCase(), pp);
                }
                catch (IOException e) {
                    log.debug(e.getMessage());
                }
            }
        }
    }

    @Override
    public void register() {
        IOFileFilter filter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{new ConvertorFileFilter()});
        FileAlterationObserver filealtertionObserver = new FileAlterationObserver(file, (FileFilter)filter);
        filealtertionObserver.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onDirectoryCreate(File directory) {
                ConverterContextListener.this.refresh();
                super.onDirectoryCreate(directory);
            }

            public void onDirectoryDelete(File directory) {
                ConverterContextListener.this.refresh();
                super.onDirectoryDelete(directory);
            }

            public void onFileChange(File file) {
                log.info("{}\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u6587\u4ef6\u53d1\u751f\u4e86\u53d8\u5316", (Object)file.getName());
                ConverterContextListener.this.refresh();
                super.onFileChange(file);
            }

            public void onFileCreate(File file) {
                ConverterContextListener.this.refresh();
                super.onFileCreate(file);
            }

            public void onFileDelete(File file) {
                ConverterContextListener.this.refresh();
                super.onFileDelete(file);
            }

            public void onStart(FileAlterationObserver observer) {
                log.info("\u5f00\u59cb\u76d1\u542c>>>>>>>>>>>>>>>>>>{}", (Object)observer.getDirectory());
                super.onStart(observer);
            }
        });
        FileAlterationMonitor filealterationMonitor = new FileAlterationMonitor(this.listenerProperties.getListenerTime());
        filealterationMonitor.addObserver(filealtertionObserver);
        filealterationMonitor.start();
        log.debug("\u76d1\u542c\u4e86\u6587\u4ef6\u5939{}\u5185\u7684\u6587\u4ef6", (Object)file.getName());
    }

    public void refresh() {
        properties.clear();
        this.initProperties();
    }

    class ConvertorFileFilter
    implements IOFileFilter {
        ConvertorFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".properties");
        }

        public boolean accept(File dir, String name) {
            return true;
        }
    }
}

