/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.rateLimit.RateLimiterHandler;

import cn.hutool.core.date.DateUtil;
import com.tuoren.common.commponent.rateLimit.RateLimiterHandler.Interface.RateLimiterHandler;
import com.tuoren.common.commponent.rateLimit.RateLimiterProperties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@ConditionalOnProperty(prefix="ratelimit", name={"type"}, havingValue="tokenbucket")
public class TokenBucketHandler
implements RateLimiterHandler {
    private static final Logger log = LoggerFactory.getLogger(TokenBucketHandler.class);
    private int bucketSize;
    private AtomicLong storedPermits = new AtomicLong(0L);
    private AtomicLong lastRefillTime = new AtomicLong(0L);
    private long rate;
    private long millsWait;
    @Autowired
    RateLimiterProperties tokenBucketProperties;

    @PostConstruct
    public void init() {
        this.bucketSize = this.tokenBucketProperties.getBucketSize();
        this.rate = this.tokenBucketProperties.getRate();
        this.millsWait = TimeUnit.SECONDS.toMillis(this.tokenBucketProperties.getWaitTime());
        this.storedPermits.set(this.bucketSize / 2);
        this.lastRefillTime.set(System.currentTimeMillis());
        log.info("\u4ee4\u724c\u6876\u53c2\u6570\u8bbe\u7f6e\u6210\u529f\uff0c\u6876\u5927\u5c0f\u4e3a--{}\uff0c\u901f\u7387--{}ms/\u4e2a,\u6700\u5927\u7b49\u5f85\u65f6\u95f4--{}ms,\u5f53\u524d\u6876\u4e2d\u5b58\u50a8\u4ee4\u724c\u6570\u91cf--{}", new Object[]{this.bucketSize, this.rate, this.millsWait, this.storedPermits.get()});
    }

    @Override
    public boolean acquire() {
        return this.tryAcquire(1L, this.millsWait, System.currentTimeMillis());
    }

    public boolean acquire(long needPermits) {
        return this.tryAcquire(needPermits, this.millsWait, System.currentTimeMillis());
    }

    public boolean acquire(long needPermits, TimeUnit unit) {
        return this.tryAcquire(unit.toMillis(needPermits), 0L, System.currentTimeMillis());
    }

    boolean tryAcquire(long needPermits, long millsToWait, long now) {
        if (!this.checkPermits(needPermits)) {
            return false;
        }
        this.refillPermits(this.bucketSize, this.rate, System.currentTimeMillis());
        if (this.consumerToken((int)needPermits)) {
            return true;
        }
        return this.waitToGetPermits(needPermits, now, millsToWait);
    }

    boolean checkPermits(long needPermits) {
        if (this.bucketSize <= 0 || this.rate <= 0L || needPermits > (long)this.bucketSize) {
            return false;
        }
        if (this.storedPermits.get() == -1L) {
            this.storedPermits.set(this.bucketSize / 2);
        }
        return true;
    }

    private void refillPermits(int bucketSize, long rate, long nowMills) {
        long lastTime = this.lastRefillTime.get();
        long interval = nowMills - lastTime;
        long newTokens = interval / rate;
        if (newTokens > 0L) {
            long newFillTime;
            long l = newFillTime = lastTime == 0L ? nowMills : lastTime + newTokens * rate;
            if (this.lastRefillTime.compareAndSet(lastTime, newFillTime)) {
                long adjust;
                long l2;
                while (!this.storedPermits.compareAndSet(l2 = this.storedPermits.get(), adjust = Math.min(l2 + newTokens, (long)bucketSize))) {
                }
                return;
            }
        }
    }

    private boolean consumerToken(int consumerTokens) {
        long storePermits;
        do {
            if ((storePermits = this.storedPermits.get()) >= (long)consumerTokens) continue;
            return false;
        } while (!this.storedPermits.compareAndSet(storePermits, Math.max(0L, storePermits - 1L)));
        log.info("\u5f53\u524d\u65f6\u95f4---{}\uff0c\u6d88\u8d39\u4ee4\u724c\u6570\u91cf--{}\uff0c\u5269\u4f59\u4ee4\u724c\u6570\u91cf--{}", new Object[]{DateUtil.now(), consumerTokens, this.storedPermits.get()});
        return true;
    }

    private boolean waitToGetPermits(long needPermits, long now, long waitMillsTime) {
        long timeMillis;
        if (waitMillsTime <= 0L) {
            return false;
        }
        long targetTime = now + waitMillsTime;
        while ((timeMillis = System.currentTimeMillis()) < targetTime) {
        }
        return this.tryAcquire(needPermits, 0L, timeMillis);
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public AtomicLong getStoredPermits() {
        return this.storedPermits;
    }

    public AtomicLong getLastRefillTime() {
        return this.lastRefillTime;
    }

    public long getRate() {
        return this.rate;
    }

    public long getMillsWait() {
        return this.millsWait;
    }

    public RateLimiterProperties getTokenBucketProperties() {
        return this.tokenBucketProperties;
    }

    public void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public void setStoredPermits(AtomicLong storedPermits) {
        this.storedPermits = storedPermits;
    }

    public void setLastRefillTime(AtomicLong lastRefillTime) {
        this.lastRefillTime = lastRefillTime;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public void setMillsWait(long millsWait) {
        this.millsWait = millsWait;
    }

    public void setTokenBucketProperties(RateLimiterProperties tokenBucketProperties) {
        this.tokenBucketProperties = tokenBucketProperties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenBucketHandler)) {
            return false;
        }
        TokenBucketHandler other = (TokenBucketHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBucketSize() != other.getBucketSize()) {
            return false;
        }
        AtomicLong this$storedPermits = this.getStoredPermits();
        AtomicLong other$storedPermits = other.getStoredPermits();
        if (this$storedPermits == null ? other$storedPermits != null : !this$storedPermits.equals(other$storedPermits)) {
            return false;
        }
        AtomicLong this$lastRefillTime = this.getLastRefillTime();
        AtomicLong other$lastRefillTime = other.getLastRefillTime();
        if (this$lastRefillTime == null ? other$lastRefillTime != null : !this$lastRefillTime.equals(other$lastRefillTime)) {
            return false;
        }
        if (this.getRate() != other.getRate()) {
            return false;
        }
        if (this.getMillsWait() != other.getMillsWait()) {
            return false;
        }
        RateLimiterProperties this$tokenBucketProperties = this.getTokenBucketProperties();
        RateLimiterProperties other$tokenBucketProperties = other.getTokenBucketProperties();
        return !(this$tokenBucketProperties == null ? other$tokenBucketProperties != null : !((Object)this$tokenBucketProperties).equals(other$tokenBucketProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenBucketHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBucketSize();
        AtomicLong $storedPermits = this.getStoredPermits();
        result = result * 59 + ($storedPermits == null ? 43 : $storedPermits.hashCode());
        AtomicLong $lastRefillTime = this.getLastRefillTime();
        result = result * 59 + ($lastRefillTime == null ? 43 : $lastRefillTime.hashCode());
        long $rate = this.getRate();
        result = result * 59 + (int)($rate >>> 32 ^ $rate);
        long $millsWait = this.getMillsWait();
        result = result * 59 + (int)($millsWait >>> 32 ^ $millsWait);
        RateLimiterProperties $tokenBucketProperties = this.getTokenBucketProperties();
        result = result * 59 + ($tokenBucketProperties == null ? 43 : ((Object)$tokenBucketProperties).hashCode());
        return result;
    }

    public String toString() {
        return "TokenBucketHandler(bucketSize=" + this.getBucketSize() + ", storedPermits=" + this.getStoredPermits() + ", lastRefillTime=" + this.getLastRefillTime() + ", rate=" + this.getRate() + ", millsWait=" + this.getMillsWait() + ", tokenBucketProperties=" + this.getTokenBucketProperties() + ")";
    }
}

