/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.config;

import com.tuoren.common.entity.MvcEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class MvcConfig {
    public static final Map<MvcEntity, AtomicInteger> URLMAP = new HashMap<MvcEntity, AtomicInteger>();
    public static final ReentrantReadWriteLock LOCK = new ReentrantReadWriteLock();
    @Autowired
    WebApplicationContext webApplicationContext;

    @PostConstruct
    public void init() {
        this.fillAllUrl();
    }

    public void fillAllUrl() {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.webApplicationContext.getBean(RequestMappingHandlerMapping.class);
        Map handlerMethods = mapping.getHandlerMethods();
        handlerMethods.forEach((requestMappingInfo, handlerMethod) -> {
            MvcEntity mvcEntity = new MvcEntity(handlerMethod.getMethod().getName(), handlerMethod.getBeanType().getName(), requestMappingInfo.getMethodsCondition().getMethods().toString().replaceAll("\\[", "").replaceAll("\\]", ""), requestMappingInfo.getPatternsCondition().toString());
            Api api = handlerMethod.getBeanType().getAnnotation(Api.class);
            ApiOperation apiOperation = handlerMethod.getMethod().getAnnotation(ApiOperation.class);
            if (api != null && apiOperation != null) {
                mvcEntity.setDescription(api.description() + ":" + apiOperation.value());
            }
            URLMAP.put(mvcEntity, new AtomicInteger(0));
        });
    }
}

