/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.crazycake.shiro.RedisManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@EnableConfigurationProperties(value={RedisProperties.class})
public class RedisConfig {
    private static final String SALT = "netpump";
    private RedisProperties redisProperties;
    private RedisManager redisManager;

    @Autowired
    public RedisConfig(RedisProperties redisProperties, RedisManager redisManager) {
        this.redisProperties = redisProperties;
        this.redisManager = redisManager;
    }

    @Bean
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(redisConnectionFactory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        objectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(objectMapper);
        redisTemplate.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    public void init() {
        String originPassword = this.redisProperties.getPassword();
        String newPassword = this.getEncryption(originPassword + SALT) + "\\.";
        this.redisProperties.setPassword(newPassword);
        this.redisManager.setPassword(newPassword);
    }

    private String getEncryption(String originString) {
        String result = null;
        if (originString != null) {
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] bytes = md.digest(originString.getBytes());
                for (int i = 0; i < bytes.length; ++i) {
                    String str = Integer.toHexString(bytes[i] & 0xFF);
                    if (str.length() == 1) {
                        str = str + "F";
                    }
                    result = result + str;
                }
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        result = result.toUpperCase();
        return result.substring(result.length() / 2);
    }

    public RedisConfig() {
    }
}

