/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.exception;

import com.tuoren.common.api.CommonResult;
import com.tuoren.common.api.ResultCode;
import com.tuoren.common.exception.ApiException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    @ResponseBody
    @ExceptionHandler(value={ApiException.class})
    public CommonResult handle(ApiException e) {
        if (e.getErrorCode() != null) {
            return CommonResult.failed(e.getErrorCode());
        }
        return CommonResult.failed(e.getMessage());
    }

    @ResponseBody
    @ExceptionHandler(value={AuthorizationException.class})
    public CommonResult defaultErrorHandler() {
        return CommonResult.failed(ResultCode.FORBIDDEN);
    }

    @ResponseBody
    @ExceptionHandler(value={AuthenticationException.class})
    public CommonResult shiroAuthHandler() {
        return CommonResult.failed(ResultCode.FORBIDDEN);
    }

    @ResponseBody
    @ExceptionHandler(value={AccountException.class})
    public CommonResult shiroAccoundHandler() {
        return CommonResult.failed(ResultCode.UNAUTHORIZED);
    }

    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    public CommonResult defaultAuthorizedExceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception e) {
        return CommonResult.failed("\u672a\u6388\u6743");
    }

    @ExceptionHandler(value={UnauthenticatedException.class})
    @ResponseBody
    public CommonResult defaultAuthenticatedExceptionHandler(HttpServletRequest request, HttpServletResponse response, Exception e) {
        return CommonResult.failed("\u672a\u8ba4\u8bc1");
    }
}

