/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.redis.impl;

import cn.hutool.json.JSONUtil;
import com.tuoren.common.redis.RedisService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.stereotype.Service;

@Service
public class RedisServiceImpl
implements RedisService {
    private static final Logger log = LoggerFactory.getLogger(RedisServiceImpl.class);
    @Autowired
    private RedisTemplate stringRedisTemplate;

    @Override
    public void set(String key, String value) {
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    @Override
    public String get(String key) {
        Object result = this.stringRedisTemplate.opsForValue().get((Object)key);
        return result == null ? null : String.valueOf(result);
    }

    @Override
    public Object get(String key, Class cls) {
        Object result = this.stringRedisTemplate.opsForValue().get((Object)key);
        JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)result), (Class)cls);
        return result == null ? null : JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)result), (Class)cls);
    }

    @Override
    public boolean expire(String key, long expire) {
        return this.stringRedisTemplate.expire((Object)key, expire, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        this.stringRedisTemplate.delete((Object)key);
    }

    @Override
    public long remove(Collection keys) {
        return this.stringRedisTemplate.delete(keys);
    }

    @Override
    public Long increment(String key, long delta) {
        return this.stringRedisTemplate.opsForValue().increment((Object)key, delta);
    }

    @Override
    public Set<String> getKeys(String key) {
        return this.stringRedisTemplate.keys((Object)key);
    }

    @Override
    public void setAndExpire(String key, String value, long expireTime) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(key);
        keys.add(value);
        this.runLua("/lua/setAndExpire.lua", String.class, keys, String.valueOf(expireTime));
    }

    @Override
    public <T> T runLua(String fileClasspath, Class<T> returnType, List<String> keys, Object ... values) {
        DefaultRedisScript redisScript = new DefaultRedisScript();
        ResourceScriptSource resourceScriptSource = new ResourceScriptSource((Resource)new ClassPathResource(fileClasspath));
        redisScript.setScriptSource((ScriptSource)resourceScriptSource);
        redisScript.setResultType(returnType);
        Object execute = null;
        try {
            execute = this.stringRedisTemplate.execute((RedisScript)redisScript, keys, values);
        }
        catch (Exception e) {
            log.error("keys---{},values---{},luaScript running breakdown,{}", new Object[]{keys.toString(), Arrays.toString(values), e.getMessage()});
        }
        return (T)execute;
    }
}

