/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.utils;

import java.util.TimerTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncManager {
    private ThreadLocal<ScheduledThreadPoolExecutor> threadLocal = new ThreadLocal();

    private AsyncManager() {
    }

    private ScheduledThreadPoolExecutor getExecutor() {
        ScheduledThreadPoolExecutor executor = this.threadLocal.get();
        if (executor == null) {
            executor = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        this.threadLocal.set(executor);
        return executor;
    }

    public static AsyncManager getAsyncManager() {
        return AsyncManagerFactory.getAsyncManager();
    }

    public void execute(TimerTask task) {
        ScheduledThreadPoolExecutor executor = this.getExecutor();
        executor.execute(task);
    }

    public void execute(TimerTask task, long delay) {
        ScheduledThreadPoolExecutor executor = this.getExecutor();
        executor.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    public void execute(TimerTask task, long delay, TimeUnit timeUnit) {
        ScheduledThreadPoolExecutor executor = this.getExecutor();
        executor.schedule(task, delay, timeUnit);
    }

    private static class AsyncManagerFactory {
        static AsyncManager asyncManager = new AsyncManager();

        private AsyncManagerFactory() {
        }

        static AsyncManager getAsyncManager() {
            return asyncManager;
        }
    }
}

