/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.common.redis.RedisService;
import com.tuoren.common.utils.enums.LogType;
import com.tuoren.web.layer.entity.BusAnalgesicScoreEntity;
import com.tuoren.web.layer.service.IBusAnalgesicScoreService;
import com.tuoren.web.layer.service.ISysBreathService;
import com.tuoren.web.layer.vo.AnalgesicScoreParam;
import com.tuoren.web.utils.ConverterUtils;
import com.tuoren.web.utils.DataUtils;
import com.tuoren.web.utils.DateFormatUtils;
import com.tuoren.web.utils.LogUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BusAnalgesicScoreController"}, description="\u8bc4\u5206\u548c\u968f\u8bbf\u4eba\u5458")
@RestController
@RequestMapping(value={"/bus/analgesic-score"})
public class BusAnalgesicScoreController {
    private static final Logger log = LoggerFactory.getLogger(BusAnalgesicScoreController.class);
    @Autowired
    public IBusAnalgesicScoreService iBusAnalgesicScoreEntityService;
    @Autowired
    public RedisService redisService;
    @Autowired
    public ISysBreathService iSysBreathService;
    @Autowired
    public RabbitTemplate rabbitTemplate;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, BusAnalgesicScoreEntity busAnalgesicScoreEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper((Object)busAnalgesicScoreEntity);
        wrapper.orderByDesc((Object)"follow_date");
        return CommonResult.success((Object)this.iBusAnalgesicScoreEntityService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iBusAnalgesicScoreEntityService.getById(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    @RabbitHandler
    public CommonResult insert(@RequestBody @Validated BusAnalgesicScoreEntity busAnalgesicScoreEntity) {
        String hospital = busAnalgesicScoreEntity.getHospitalCode();
        try {
            busAnalgesicScoreEntity.setFollowDate(DateFormatUtils.format(DateUtil.now()));
            this.iBusAnalgesicScoreEntityService.insertAcqId(busAnalgesicScoreEntity);
            busAnalgesicScoreEntity.setAnalgesicScoreId(busAnalgesicScoreEntity.getId().toString());
            CommonResult commonResult = CommonResult.success((Object)"\u6dfb\u52a0\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            CommonResult commonResult = CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
            return commonResult;
        }
        finally {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("operation", (Object)1);
            jsonObject.put("tableName", (Object)"AnalgesicScore");
            jsonObject.put("data", JSON.toJSON((Object)busAnalgesicScoreEntity));
            this.pushRabbit(jsonObject, hospital, busAnalgesicScoreEntity);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody BusAnalgesicScoreEntity busAnalgesicScoreEntity) {
        try {
            return CommonResult.success((Object)this.iBusAnalgesicScoreEntityService.updateById(busAnalgesicScoreEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.success((Object)this.iBusAnalgesicScoreEntityService.removeByIds(idList), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0d\u91cd\u590d\u7684\u968f\u8bbf\u4eba\u5458")
    @PostMapping(value={"/getFollowUp"})
    public CommonResult getFollowUp(@RequestBody AnalgesicScoreParam analgesicScoreParam) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)analgesicScoreParam.getProductCode()), (Object)"product_code", (Object)analgesicScoreParam.getProductCode());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)analgesicScoreParam.getHospitalCode()), (Object)"hospital_code", (Object)analgesicScoreParam.getHospitalCode());
        wrapper.select(new String[]{" creator "});
        wrapper.last("limit " + analgesicScoreParam.getPageSize());
        wrapper.groupBy((Object)"creator");
        wrapper.orderByDesc((Object)"max(gmt_modified)");
        return CommonResult.success((Object)this.iBusAnalgesicScoreEntityService.listObjs((Wrapper)wrapper));
    }

    @ApiOperation(value="\u6839\u636e\u4f4f\u9662\u53f7\u548c\u75c5\u4ebaID\u548c\u6240\u5728\u533b\u9662\u83b7\u53d6\u6700\u65b0\u8bc4\u5206\u4fe1\u606f")
    @PostMapping(value={"/getNewScore"})
    public CommonResult getNewScore(@RequestBody AnalgesicScoreParam analgesicScoreParam) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(StrUtil.isNotBlank((CharSequence)analgesicScoreParam.getProductCode()), (Object)"product_code", (Object)analgesicScoreParam.getProductCode());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)analgesicScoreParam.getHospitalCode()), (Object)"hospital_code", (Object)analgesicScoreParam.getHospitalCode());
        wrapper.eq(StrUtil.isNotBlank((CharSequence)analgesicScoreParam.getPatientCode()), (Object)"patient_code", (Object)analgesicScoreParam.getPatientCode());
        wrapper.select(new String[]{"*"});
        wrapper.last("limit 1");
        wrapper.orderByDesc((Object)"gmt_modified");
        return CommonResult.success((Object)this.iBusAnalgesicScoreEntityService.getOne((Wrapper)wrapper));
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u8bc4\u5206 \u4f4f\u9662\u53f7 patientCode | \u6cf5\u53f7 pumpCode | \u4ea7\u54c1\u7f16\u7801\u7c7b\u578b productCode | \u533b\u9662 hospitalCode | \u521b\u5efa\u4eba creator ")
    @GetMapping(value={"/getFuzzyScore"})
    public CommonResult getFuzzyScore(@RequestBody AnalgesicScoreParam analgesicScoreParam) {
        try {
            IPage<BusAnalgesicScoreEntity> iPage = this.iBusAnalgesicScoreEntityService.queryFuzzyScore(analgesicScoreParam);
            if (iPage.getRecords().size() > 0) {
                return CommonResult.success(iPage);
            }
            return CommonResult.noData();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    private void pushRabbit(JSONObject jsonObject, String hospital, BusAnalgesicScoreEntity busAnalgesicScoreEntity) {
        try {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"code", (Object)busAnalgesicScoreEntity.getHospitalCode());
            log.info("\u63a8\u9001\u8bc4\u5206\u5230Rabbit,{}", (Object)JSONUtil.toJsonStr((Object)jsonObject));
            JSON convert = ConverterUtils.convert(jsonObject, BusAnalgesicScoreEntity.class, ConverterUtils.ConverterType.Cloud2PC);
            this.rabbitTemplate.convertAndSend("hospital." + hospital, (Object)DataUtils.stringToByte(convert), new CorrelationData(convert.toJSONString()));
            LogUtils.save(LogType.MqInfo, convert);
        }
        catch (Exception e) {
            log.info("\u63a8\u9001\u8bc4\u5206\u5230Rabbit \u51fa\u73b0\u9519\u8bef>>>>>>>" + e.getMessage());
        }
    }
}

