/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.web.layer.entity.BusHospitalEntity;
import com.tuoren.web.layer.service.IBusHospitalService;
import com.tuoren.web.layer.vo.HospitalParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BusHospitalController"}, description="\u533b\u9662\u7ba1\u7406")
@RestController
@RequestMapping(value={"/bus/hospital"})
public class BusHospitalController {
    private static final Logger log = LoggerFactory.getLogger(BusHospitalController.class);
    @Autowired
    public IBusHospitalService iBusHospitalEntityService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, BusHospitalEntity busHospitalEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper((Object)busHospitalEntity);
        wrapper.orderByDesc((Object)"gmt_modified");
        return CommonResult.success((Object)this.iBusHospitalEntityService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iBusHospitalEntityService.getById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public CommonResult insert(@RequestBody BusHospitalEntity busHospitalEntity) {
        try {
            busHospitalEntity.setHospitalCode(IdUtil.simpleUUID());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"hosptial_name", (Object)busHospitalEntity.getHosptialName());
            List list = this.iBusHospitalEntityService.list((Wrapper)wrapper);
            if (list.size() > 0) {
                return CommonResult.failed((String)"\u533b\u9662\u540d\u79f0\u91cd\u590d");
            }
            return CommonResult.success((Object)this.iBusHospitalEntityService.save(busHospitalEntity), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody BusHospitalEntity busHospitalEntity) {
        try {
            return CommonResult.success((Object)this.iBusHospitalEntityService.updateById(busHospitalEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.failed((String)"\u533b\u9662\u65e0\u6cd5\u5220\u9664");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u533b\u9662 \u533b\u9662\u540d\u5b57 hosptialName | \u533b\u9662\u7f16\u53f7 hospitalCode | \u7701\u7f16\u7801 provinceCode | \u5e02\u7f16\u7801 cityCode | \u533a\u7f16\u7801 areaCode")
    @PostMapping(value={"/getFuzzyHospital"})
    public CommonResult getFuzzyHospital(@RequestBody HospitalParam hospitalParam) {
        try {
            IPage<BusHospitalEntity> iPage = this.iBusHospitalEntityService.queryFuzzyHospital(hospitalParam);
            if (iPage.getRecords().size() > 0) {
                return CommonResult.success(iPage);
            }
            return CommonResult.noData();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }
}

