/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tuoren.web.layer.d0.PumpVo;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.entity.BusReceiveRecordCopyEntity;
import com.tuoren.web.layer.entity.BusReceiveRecordEntity;
import com.tuoren.web.layer.mapper.BusPumpMapper;
import com.tuoren.web.layer.mapper.BusReceiveRecordCopyMapper;
import com.tuoren.web.layer.mapper.BusReceiveRecordMapper;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.vo.PumpParam;
import com.tuoren.web.rabbit.RabbitHandle;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class BusPumpServiceImpl
extends ServiceImpl<BusPumpMapper, BusPumpEntity>
implements IBusPumpService {
    @Autowired
    BusReceiveRecordMapper busReceiveRecordMapper;
    @Autowired
    BusReceiveRecordCopyMapper busReceiveRecordCopyMapper;
    @Autowired
    @Lazy
    private RabbitHandle rabbitHandle;

    @Override
    public void pumpRabbitHandle(BusPumpEntity record) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pump_code", (Object)record.getPumpCode());
        BusPumpEntity existRecord = (BusPumpEntity)this.getOne((Wrapper)wrapper);
        if (existRecord == null) {
            this.save(record);
        } else {
            if (record.getLastUploadTime().compareTo(existRecord.getLastUploadTime()) < 0) {
                return;
            }
            record.setId(existRecord.getId());
            this.updateById(record);
        }
        BusReceiveRecordEntity receiveRecord = new BusReceiveRecordEntity();
        BeanUtils.copyProperties((Object)record, (Object)receiveRecord);
        receiveRecord.setId(null);
        this.busReceiveRecordMapper.insert(receiveRecord);
    }

    @Override
    public void pumpRabbitCopyHandle(BusPumpEntity record) {
        BusReceiveRecordCopyEntity receiveCopyCopyRecord = new BusReceiveRecordCopyEntity();
        BeanUtils.copyProperties((Object)record, (Object)receiveCopyCopyRecord);
        receiveCopyCopyRecord.setId(null);
        this.busReceiveRecordCopyMapper.insert(receiveCopyCopyRecord);
    }

    @Override
    public IPage<BusPumpEntity> queryPumpList(Integer pageNo, Integer pageSize, BusPumpEntity resources) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().like(StrUtil.isNotEmpty((CharSequence)resources.getPumpCode()), BusPumpEntity::getPumpCode, (Object)resources.getPumpCode())).eq(StrUtil.isNotEmpty((CharSequence)resources.getHospitalCode()), BusPumpEntity::getHospitalCode, (Object)resources.getHospitalCode())).eq(resources.getStateFlag() != null, BusPumpEntity::getStateFlag, (Object)resources.getStateFlag())).eq(StrUtil.isNotEmpty((CharSequence)resources.getProductCode()), BusPumpEntity::getProductCode, (Object)resources.getProductCode())).like(StrUtil.isNotEmpty((CharSequence)resources.getPatientCode()), BusPumpEntity::getPatientCode, (Object)resources.getPatientCode())).orderByDesc(BusPumpEntity::getLastUploadTime);
        return this.page((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public IPage<PumpVo> queryPumpListByCustom(PumpParam pumpParam) {
        Page iPage = new Page((long)pumpParam.getPageNo().intValue(), (long)pumpParam.getPageSize().intValue());
        List<PumpVo> list = ((BusPumpMapper)this.getBaseMapper()).queryPumpListByCustom((IPage<PumpVo>)iPage, pumpParam.getUserCode(), pumpParam.getPatientCode(), pumpParam.getWard(), pumpParam.getBedNo(), pumpParam.getPatientName(), pumpParam.getDoctor(), pumpParam.getSex(), pumpParam.getAnesthesiaMode(), pumpParam.getOperation(), pumpParam.getHospitalCode(), pumpParam.getProductCode(), pumpParam.getStateFlag());
        iPage.setRecords(list);
        return iPage;
    }

    @Override
    public IPage<PumpVo> queryPumpListByUser(PumpParam pumpParam) {
        Page iPage = new Page((long)pumpParam.getPageNo().intValue(), (long)pumpParam.getPageSize().intValue());
        List<PumpVo> list = ((BusPumpMapper)this.getBaseMapper()).queryPumpListByUser((IPage<PumpVo>)iPage, pumpParam.getUserCode(), pumpParam.getStateFlag(), pumpParam.getRunState(), pumpParam.getUpAndDown(), pumpParam.getBufState9(), pumpParam.getHospitalCode(), pumpParam.getProductCode());
        iPage.setRecords(list);
        return iPage;
    }

    @Override
    public List<PumpVo> queryPumpWarnListByUser(PumpParam pumpParam) {
        return ((BusPumpMapper)this.getBaseMapper()).queryPumpWarnListByUser(pumpParam.getUserCode(), pumpParam.getStateFlag(), pumpParam.getBufState9(), pumpParam.getPumpCode(), pumpParam.getHospitalCode(), pumpParam.getProductCode());
    }

    @Override
    public List<PumpVo> queryPumpInfo(PumpParam pumpParam) {
        return ((BusPumpMapper)this.getBaseMapper()).queryPumpInfo(pumpParam.getPatientCode(), pumpParam.getPumpCode(), pumpParam.getHospitalCode());
    }

    @Override
    public void removePump(List<String> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        Collection pumps = this.listByIds(ids);
        if (CollectionUtil.isEmpty((Collection)pumps)) {
            return;
        }
        Map<String, List<BusPumpEntity>> pumpMap = pumps.stream().peek(p -> p.setIsRemove(Boolean.FALSE)).collect(Collectors.groupingBy(BusPumpEntity::getHospitalCode));
        this.updateBatchById(pumps);
        try {
            this.rabbitHandle.sendRemovePump(pumpMap);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

