/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.flowMonitor;

import com.tuoren.common.config.MvcConfig;
import com.tuoren.common.entity.MvcEntity;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class FlowMonitorMethodInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getThis().getClass().getName().contains("$$Enhancer")) {
            return invocation.proceed();
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        this.logFlow(invocation, request);
        return invocation.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logFlow(MethodInvocation invocation, HttpServletRequest request) {
        Map<MvcEntity, AtomicInteger> urlmap = MvcConfig.URLMAP;
        MvcEntity mvcEntity = this.getMvcEntity(invocation, request);
        MvcConfig.LOCK.readLock().lock();
        try {
            AtomicInteger atomicInteger = urlmap.get(mvcEntity);
            atomicInteger.getAndIncrement();
        }
        finally {
            MvcConfig.LOCK.readLock().unlock();
        }
    }

    private MvcEntity getMvcEntity(MethodInvocation invocation, HttpServletRequest request) {
        Method method = invocation.getMethod();
        String className = invocation.getThis().getClass().getName();
        MvcEntity mvcEntity = new MvcEntity();
        mvcEntity.setMethodName(method.getName());
        mvcEntity.setClassName(className);
        mvcEntity.setOperation(request.getMethod());
        return mvcEntity;
    }
}

