/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.idempotent;

import com.tuoren.common.api.AopOrderEnum;
import com.tuoren.common.commponent.idempotent.IdempotentMethodInterceptor;
import com.tuoren.common.redis.RedisService;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

public class IdempotentAutoConfiguration {
    private final String POINT_CUT = "@annotation(com.tuoren.common.commponent.idempotent.annotation.Idempotent)";

    @Bean
    @ConditionalOnClass(value={RedisService.class})
    public DefaultPointcutAdvisor repeatSubmitPointCutAdvice(RedisService redisService) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("@annotation(com.tuoren.common.commponent.idempotent.annotation.Idempotent)");
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)new IdempotentMethodInterceptor(redisService));
        advisor.setOrder(AopOrderEnum.IDEMPOTENT.getOrder());
        return advisor;
    }
}

