/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.idempotent;

import com.aliyuncs.utils.StringUtils;
import com.tuoren.common.api.CommonResult;
import com.tuoren.common.api.ResultCode;
import com.tuoren.common.commponent.idempotent.annotation.Idempotent;
import com.tuoren.common.redis.RedisService;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class IdempotentMethodInterceptor
implements MethodInterceptor {
    private RedisService redisService;
    private final String LUA = "lua/del.lua";

    public IdempotentMethodInterceptor(RedisService redisService) {
        this.redisService = redisService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getThis().getClass().getName().contains("$$Enhancer")) {
            return invocation.proceed();
        }
        Method method = invocation.getMethod();
        if (method.isAnnotationPresent(Idempotent.class)) {
            Idempotent idempotent = method.getAnnotation(Idempotent.class);
            if (!idempotent.enable()) {
                return invocation.proceed();
            }
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            String token = request.getHeader("IdempotentToken");
            if (StringUtils.isEmpty((CharSequence)token)) {
                return CommonResult.failed(ResultCode.DUPLICATE);
            }
            Idempotent.Type type = idempotent.type();
            if (type == Idempotent.Type.TOKEN_AND_URL) {
                Long result = this.redisService.runLua("lua/del.lua", Long.class, Collections.singletonList(token), new Object[0]);
                if (result == 1L) {
                    return invocation.proceed();
                }
                return CommonResult.failed(ResultCode.DUPLICATE);
            }
        }
        return invocation.proceed();
    }
}

