/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.rateLimit;

import com.tuoren.common.api.AopOrderEnum;
import com.tuoren.common.commponent.rateLimit.RateLimitMethodInterceptor;
import com.tuoren.common.commponent.rateLimit.RateLimiterHandler.Interface.RateLimiterHandler;
import com.tuoren.common.commponent.rateLimit.RateLimiterProperties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@ConditionalOnProperty(prefix="ratelimit", name={"enable"}, havingValue="true")
public class RateLimiterAutoConfigration {
    private final String POINT_CUT = "execution(public * com.tuoren.web.layer.controller.*.*(..))";
    @Autowired
    RateLimiterProperties rateLimiterProperties;
    @Autowired
    RateLimiterHandler rateLimiterHandler;

    @Bean
    public DefaultPointcutAdvisor rateLimitPointCutAdvice() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression("execution(public * com.tuoren.web.layer.controller.*.*(..))");
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)new RateLimitMethodInterceptor(this.rateLimiterProperties, this.rateLimiterHandler));
        advisor.setOrder(AopOrderEnum.RATELIMIT.getOrder());
        return advisor;
    }
}

