/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.rateLimit.RateLimiterHandler;

import com.tuoren.common.commponent.rateLimit.RateLimiterHandler.Interface.RateLimiterHandler;
import com.tuoren.common.commponent.rateLimit.RateLimiterProperties;
import com.tuoren.common.redis.RedisService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={RateLimiterProperties.class})
@ConditionalOnProperty(prefix="ratelimit", name={"type"}, havingValue="redis")
public class RedisBucketHandler
implements RateLimiterHandler {
    private static final Logger log = LoggerFactory.getLogger(RedisBucketHandler.class);
    private int bucketSize;
    private long rate;
    private long millsWait;
    @Autowired
    private RedisService redisService;
    @Autowired
    RateLimiterProperties properties;

    @PostConstruct
    public void init() {
        this.bucketSize = this.properties.getBucketSize();
        this.rate = this.properties.getRate();
        this.millsWait = TimeUnit.SECONDS.toMillis(this.properties.getWaitTime());
        log.info("redis\u4ee4\u724c\u6876\u53c2\u6570\u8bbe\u7f6e\u6210\u529f\uff0c\u6876\u5927\u5c0f\u4e3a--{}\uff0c\u901f\u7387--{}ms/\u4e2a,\u6700\u5927\u7b49\u5f85\u65f6\u95f4--{}ms", new Object[]{this.bucketSize, this.rate, this.millsWait});
    }

    @Override
    public boolean acquire() {
        return this.acquire(1L, this.millsWait, System.currentTimeMillis());
    }

    private boolean acquire(long needPermits, long millsToWait, long now) {
        if (!this.checkPermits(needPermits)) {
            return false;
        }
        long consumer = this.consumer(needPermits, now);
        if (consumer == 1L) {
            return true;
        }
        if (millsToWait <= 0L) {
            return false;
        }
        return this.waitToGetPermits(needPermits, millsToWait, now);
    }

    private boolean checkPermits(long needPermits) {
        return this.bucketSize > 0 && this.rate > 0L && needPermits <= (long)this.bucketSize;
    }

    private long consumer(long needPermits, long now) {
        List<String> keys = this.getKeys();
        Long result = this.redisService.runLua("/lua/redisBucket.lua", Long.class, keys, String.valueOf(this.rate), String.valueOf(System.currentTimeMillis()));
        return result;
    }

    private boolean waitToGetPermits(long needPermits, long now, long waitMillsTime) {
        long timeMillis;
        if (waitMillsTime <= 0L) {
            return false;
        }
        long targetTime = now + waitMillsTime;
        while ((timeMillis = System.currentTimeMillis()) < targetTime) {
        }
        return this.acquire(needPermits, 0L, timeMillis);
    }

    private List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("redisBucket");
        keys.add(String.valueOf(this.bucketSize));
        return keys;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public long getRate() {
        return this.rate;
    }

    public long getMillsWait() {
        return this.millsWait;
    }

    public RedisService getRedisService() {
        return this.redisService;
    }

    public RateLimiterProperties getProperties() {
        return this.properties;
    }

    public void setBucketSize(int bucketSize) {
        this.bucketSize = bucketSize;
    }

    public void setRate(long rate) {
        this.rate = rate;
    }

    public void setMillsWait(long millsWait) {
        this.millsWait = millsWait;
    }

    public void setRedisService(RedisService redisService) {
        this.redisService = redisService;
    }

    public void setProperties(RateLimiterProperties properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisBucketHandler)) {
            return false;
        }
        RedisBucketHandler other = (RedisBucketHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getBucketSize() != other.getBucketSize()) {
            return false;
        }
        if (this.getRate() != other.getRate()) {
            return false;
        }
        if (this.getMillsWait() != other.getMillsWait()) {
            return false;
        }
        RedisService this$redisService = this.getRedisService();
        RedisService other$redisService = other.getRedisService();
        if (this$redisService == null ? other$redisService != null : !this$redisService.equals(other$redisService)) {
            return false;
        }
        RateLimiterProperties this$properties = this.getProperties();
        RateLimiterProperties other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisBucketHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBucketSize();
        long $rate = this.getRate();
        result = result * 59 + (int)($rate >>> 32 ^ $rate);
        long $millsWait = this.getMillsWait();
        result = result * 59 + (int)($millsWait >>> 32 ^ $millsWait);
        RedisService $redisService = this.getRedisService();
        result = result * 59 + ($redisService == null ? 43 : $redisService.hashCode());
        RateLimiterProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "RedisBucketHandler(bucketSize=" + this.getBucketSize() + ", rate=" + this.getRate() + ", millsWait=" + this.getMillsWait() + ", redisService=" + this.getRedisService() + ", properties=" + this.getProperties() + ")";
    }
}

