/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.commponent.shiroLogin;

import com.tuoren.common.api.CommonResult;
import com.tuoren.common.api.ResultCode;
import com.tuoren.common.redis.RedisService;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ShiroLoginMethodInterceptor
implements MethodInterceptor {
    private RedisService redisService;

    public ShiroLoginMethodInterceptor(RedisService redisService) {
        this.redisService = redisService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getThis().getClass().getName().contains("$$Enhancer")) {
            return invocation.proceed();
        }
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String authorization = request.getHeader("Authorization");
        String sessionRedisToken = "shiro:session:" + authorization;
        String portalRedisToken = "portal:user:" + authorization;
        String loginToken = this.redisService.get(sessionRedisToken);
        if (loginToken != null) {
            return invocation.proceed();
        }
        if (this.redisService.get(portalRedisToken) != null && loginToken == null) {
            this.redisService.remove(portalRedisToken);
            return CommonResult.failed(ResultCode.OCCUPIED);
        }
        return CommonResult.unauthorized();
    }
}

