/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.common.push;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.aliyuncs.utils.ParameterHelper;
import com.tuoren.common.properties.MqttPushProperties;
import com.tuoren.common.push.BasePush;
import com.tuoren.common.push.PushJsonBean;
import com.tuoren.common.utils.SpringUtil;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={MqttPushProperties.class})
public class Push
extends BasePush {
    private static final Logger log = LoggerFactory.getLogger(Push.class);
    private MqttPushProperties pushProperties;

    @PostConstruct
    public void pushInit() throws Exception {
        Push.base();
    }

    public void AdvancedPush(String account, String title, String info, String appKey) throws Exception {
        try {
            PushRequest pushRequest = new PushRequest();
            pushRequest.setProtocol(ProtocolType.HTTP);
            pushRequest.setMethod(MethodType.POST);
            pushRequest.setAppKey(Long.valueOf(appKey));
            pushRequest.setTarget("ACCOUNT");
            pushRequest.setTargetValue(account);
            pushRequest.setPushType("MESSAGE");
            pushRequest.setDeviceType("ALL");
            pushRequest.setTitle(title);
            pushRequest.setBody(info);
            pushRequest.setAndroidNotifyType("BOTH");
            pushRequest.setAndroidNotificationBarType(Integer.valueOf(1));
            pushRequest.setAndroidNotificationBarPriority(Integer.valueOf(1));
            pushRequest.setAndroidOpenType("URL");
            pushRequest.setAndroidOpenUrl("http://www.aliyun.com");
            pushRequest.setAndroidActivity("com.alibaba.push2.demo.XiaoMiPushActivity");
            pushRequest.setAndroidMusic("default");
            pushRequest.setAndroidXiaoMiActivity("com.ali.demo.MiActivity");
            pushRequest.setAndroidXiaoMiNotifyTitle("Mi title");
            pushRequest.setAndroidXiaoMiNotifyBody("MiActivity Body");
            pushRequest.setAndroidExtParameters("{\"k1\":\"android\",\"k2\":\"v2\"}");
            pushRequest.setAndroidNotificationChannel("alicloud_android_push");
            Date pushDate = new Date(System.currentTimeMillis());
            String pushTime = ParameterHelper.getISO8601Time((Date)pushDate);
            pushRequest.setPushTime(pushTime);
            String expireTime = ParameterHelper.getISO8601Time((Date)new Date(System.currentTimeMillis() + 43200000L));
            pushRequest.setExpireTime(expireTime);
            pushRequest.setStoreOffline(Boolean.valueOf(true));
            PushResponse pushResponse = (PushResponse)client.getAcsResponse((AcsRequest)pushRequest);
            log.info("RequestId: " + pushResponse.getRequestId() + ", MessageID: " + pushResponse.getMessageId() + "\n");
        }
        catch (Exception e) {
            log.info("\u63a8\u9001\u62a5\u8b66\u63a5\u53e3\u51fa\u73b0\u9519\u8bef>>>>>>> " + e.getMessage());
        }
        this.pushProperties = SpringUtil.getBean(MqttPushProperties.class);
        PushJsonBean pushJsonBean = new PushJsonBean();
        pushJsonBean.setTopic(String.format(this.pushProperties.getDefaultTopic(), account));
        pushJsonBean.setQos(this.pushProperties.getDefaultQos());
        pushJsonBean.setRetain(false);
        pushJsonBean.setPayload(info);
        pushJsonBean.setClient_id(this.pushProperties.getClientId());
        HttpRequest post = HttpUtil.createPost((String)this.pushProperties.getPushUrl());
        post.body(JSONObject.toJSONString((Object)pushJsonBean));
        post.basicAuth(this.pushProperties.getUsername(), this.pushProperties.getPassword());
        post.execute();
    }
}

