/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.commponent.webLog;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.tuoren.web.commponent.webLog.javaBean.WebLog;
import com.tuoren.web.utils.LogUtils;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebLogMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebLogMethodInterceptor.class);

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getThis().getClass().getName().contains("$$Enhancer")) {
            return invocation.proceed();
        }
        long startTime = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        WebLog webLog = new WebLog();
        Object result = invocation.proceed();
        Method method = invocation.getMethod();
        if (method.isAnnotationPresent(ApiOperation.class)) {
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            webLog.setDescription(apiOperation.value());
        }
        long endTime = System.currentTimeMillis();
        String urlStr = request.getRequestURL().toString();
        webLog.setBasePath(StrUtil.removeSuffix((CharSequence)urlStr, (CharSequence)URLUtil.url((String)urlStr).getPath()));
        webLog.setIp(request.getRemoteUser());
        webLog.setMethod(request.getMethod());
        webLog.setParameter(this.getParameter(method, invocation.getArguments()));
        webLog.setResult(result);
        webLog.setSpendTime((int)(endTime - startTime));
        webLog.setStartTime(startTime);
        webLog.setUri(request.getRequestURI());
        webLog.setUrl(request.getRequestURL().toString());
        webLog.setLogTime(DateUtil.now());
        LogUtils.success(webLog);
        return result;
    }

    private Object getParameter(Method method, Object[] args) {
        ArrayList<Object> argList = new ArrayList<Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            RequestParam requestParam;
            RequestBody requestBody = parameters[i].getAnnotation(RequestBody.class);
            if (requestBody != null) {
                argList.add(args[i]);
            }
            if ((requestParam = parameters[i].getAnnotation(RequestParam.class)) == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String key = parameters[i].getName();
            if (!StringUtils.isEmpty((Object)requestParam.value())) {
                key = requestParam.value();
            }
            map.put(key, args[i]);
            argList.add(map);
        }
        if (argList.size() == 0) {
            return null;
        }
        if (argList.size() == 1) {
            return argList.get(0);
        }
        return argList;
    }
}

