/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.job;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tuoren.web.layer.entity.SysBreathEntity;
import com.tuoren.web.layer.service.ISysBreathService;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CommonJob {
    private static final Logger log = LoggerFactory.getLogger(CommonJob.class);
    @Autowired
    private ISysBreathService iSysBreathService;

    @Scheduled(cron="0 0/2 * * * *")
    public void queueBreahJob() {
        log.info("==========queueBreahJob start=========");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"flag_online", (Object)"1");
        List entitys = this.iSysBreathService.list((Wrapper)wrapper);
        Date currentDate = new Date();
        if (entitys != null && entitys.size() > 0) {
            for (SysBreathEntity item : entitys) {
                Date breathTime = Date.from(item.getBreathTime().atZone(ZoneId.systemDefault()).toInstant());
                if (DateUtil.between((Date)breathTime, (Date)currentDate, (DateUnit)DateUnit.MINUTE) <= 15L) continue;
                item.setFlagOnline("0");
                this.iSysBreathService.updateById(item);
            }
        }
        log.info("==========queueBreahJob end=========");
    }
}

