/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.web.layer.entity.SysInterfaceFlowStatisticsEntity;
import com.tuoren.web.layer.service.ISysInterfaceFlowStatisticsService;
import com.tuoren.web.layer.vo.InterfaceFlowStatisticsParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SysInterfaceFlowStatisticsController"}, description="\u63a5\u53e3\u6d41\u91cf\u7edf\u8ba1")
@RestController
@RequestMapping(value={"/bus/interface-flow-statistics"})
public class SysInterfaceFlowStatisticsController {
    private static final Logger log = LoggerFactory.getLogger(SysInterfaceFlowStatisticsController.class);
    @Autowired
    private ISysInterfaceFlowStatisticsService statisticsService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, SysInterfaceFlowStatisticsEntity statisticsEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper((Object)statisticsEntity);
        wrapper.orderByDesc((Object)"count");
        return CommonResult.success((Object)this.statisticsService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.statisticsService.getById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public CommonResult insert(@RequestBody SysInterfaceFlowStatisticsEntity statisticsEntity) {
        try {
            return CommonResult.success((Object)this.statisticsService.save(statisticsEntity), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody SysInterfaceFlowStatisticsEntity statisticsEntity) {
        try {
            return CommonResult.success((Object)this.statisticsService.updateById(statisticsEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.success((Object)this.statisticsService.removeByIds(idList), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2")
    @GetMapping(value={"/fuzzySelect"})
    public CommonResult fuzzySelect(@RequestParam(value="idList") SysInterfaceFlowStatisticsEntity statisticsEntity) {
        try {
            QueryWrapper wrapper = new QueryWrapper((Object)statisticsEntity);
            return CommonResult.success((Object)this.statisticsService.getOne((Wrapper)wrapper), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u6a21\u7cca\u67e5\u8be2\u63a5\u53e3\u6d41\u91cf \u65b9\u6cd5\u540d methodName | \u7c7b\u540d className | \u64cd\u4f5c operation | \u6570\u91cf count | \u7edf\u8ba1\u65f6\u95f4 statisticsTime")
    @PostMapping(value={"/getFuzzyPatient"})
    public CommonResult getFuzzyPatient(@RequestBody InterfaceFlowStatisticsParam flowStatisticsParam) {
        try {
            IPage<SysInterfaceFlowStatisticsEntity> iPage;
            if (flowStatisticsParam.getStatisticsTime() == null) {
                flowStatisticsParam.setStatisticsTime(DateUtil.yesterday().toString("yyyy-MM-dd"));
            }
            if ((iPage = this.statisticsService.queryInterfaceFlowStatistics(flowStatisticsParam)).getRecords().size() > 0) {
                return CommonResult.success(iPage);
            }
            return CommonResult.noData();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6bcf\u5929\u7684\u63a5\u53e3\u6d41\u91cf\u603b\u6570")
    @GetMapping(value={"/getFlowPerDay"})
    public CommonResult getFlowPerDay() {
        try {
            return CommonResult.success(this.statisticsService.getFlowPerDay(), (String)"\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u67e5\u8be2\u5931\u8d25");
        }
    }
}

