/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.common.utils.ConstastUtils;
import com.tuoren.web.layer.entity.SysPermissionEntity;
import com.tuoren.web.layer.entity.SysRoleEntity;
import com.tuoren.web.layer.entity.SysUserEntity;
import com.tuoren.web.layer.service.ISysRoleService;
import com.tuoren.web.layer.service.ISysUserRoleService;
import com.tuoren.web.layer.service.ISysUserService;
import com.tuoren.web.layer.vo.UserChangePwdParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SysUserController"}, description="\u7528\u6237\u7ba1\u7406")
@RestController
@RequestMapping(value={"/sys/user"})
public class SysUserController {
    private static final Logger log = LoggerFactory.getLogger(SysUserController.class);
    @Autowired
    public ISysUserService iSysUserEntityService;
    @Autowired
    public ISysUserRoleService iSysUserRoleService;
    @Autowired
    public ISysRoleService iSysRoleService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, SysUserEntity sysUserEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper((Object)sysUserEntity);
        wrapper.orderByDesc((Object)"gmt_modified");
        return CommonResult.success((Object)this.iSysUserEntityService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iSysUserEntityService.getById(id));
    }

    @ApiOperation(value="\u7528\u6237\u6ce8\u518c")
    @PostMapping
    public CommonResult insert(@RequestBody SysUserEntity sysUserEntity) {
        try {
            SysUserEntity user = (SysUserEntity)this.iSysUserEntityService.getById((Serializable)((Object)sysUserEntity.getUserCode()));
            if (user != null) {
                return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25,\u767b\u5f55\u8d26\u6237\u91cd\u590d");
            }
            String salt = IdUtil.simpleUUID().toUpperCase();
            sysUserEntity.setSalt(salt);
            sysUserEntity.setPassword(new Md5Hash((Object)sysUserEntity.getPassword(), (Object)salt, 2).toString());
            this.iSysUserEntityService.save(sysUserEntity);
            return CommonResult.success((Object)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u4fee\u6539\u7528\u6237\u6570\u636e,\u53ef\u91cd\u7f6e\u5bc6\u7801")
    @PostMapping(value={"/updateUser"})
    public CommonResult update(@RequestBody SysUserEntity sysUserEntity) {
        try {
            if (sysUserEntity.getPassword() != null) {
                String salt = IdUtil.simpleUUID().toUpperCase();
                sysUserEntity.setSalt(salt);
                sysUserEntity.setPassword(new Md5Hash((Object)sysUserEntity.getPassword(), (Object)salt, 2).toString());
            }
            return CommonResult.success((Object)this.iSysUserEntityService.updateById(sysUserEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<String> idList) {
        try {
            for (String id : idList) {
                SysUserEntity byId = (SysUserEntity)this.iSysUserEntityService.getById((Serializable)((Object)id));
                Integer id1 = byId.getId();
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.eq((Object)"user_id", (Object)id1);
                this.iSysUserRoleService.remove((Wrapper)wrapper);
                this.iSysUserEntityService.removeById((Serializable)((Object)id));
            }
            return CommonResult.success((Object)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7528\u6237\u7684\u5bc6\u7801")
    @PostMapping(value={"changePwd"})
    public CommonResult changePassword(@RequestBody UserChangePwdParam userChangePwdParam) throws Exception {
        SysUserEntity user = (SysUserEntity)this.iSysUserEntityService.getById((Serializable)((Object)userChangePwdParam.getUserCode()));
        String pwd = user.getPassword();
        String salt = user.getSalt();
        String oldPassword1 = new Md5Hash((Object)userChangePwdParam.getOldPassword(), (Object)salt, ConstastUtils.HASHITERATIONS.intValue()).toString();
        if (!pwd.equals(oldPassword1)) {
            return CommonResult.failed((String)"\u8f93\u5165\u7684\u65e7\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        String oldPassword2 = new Md5Hash((Object)userChangePwdParam.getNewPwdTwo(), (Object)salt, ConstastUtils.HASHITERATIONS.intValue()).toString();
        if (oldPassword2.equals(pwd)) {
            return CommonResult.failed((String)"\u4e0e\u539f\u5bc6\u7801\u4e00\u81f4,\u4fee\u6539\u5931\u8d25");
        }
        if (userChangePwdParam.getNewPwdOne().equals(userChangePwdParam.getNewPwdTwo())) {
            String newPassword = new Md5Hash((Object)userChangePwdParam.getNewPwdOne(), (Object)salt, ConstastUtils.HASHITERATIONS.intValue()).toString();
            user.setPassword(newPassword);
            this.iSysUserEntityService.updateById(user);
            return CommonResult.success((Object)"\u4fdd\u5b58\u6210\u529f");
        }
        return CommonResult.failed((String)"\u4fdd\u5b58\u5931\u8d25");
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u67e5\u8be2\u89d2\u8272")
    @GetMapping(value={"queryRoleByUID"})
    public CommonResult queryRoleByUID(@RequestParam(value="uid") Integer uid) {
        List<SysRoleEntity> sysRoleEntities = this.iSysUserEntityService.queryRoleByUID(uid);
        if (sysRoleEntities.size() > 0 && sysRoleEntities.get(0) != null) {
            return CommonResult.success(this.iSysUserEntityService.queryRoleByUID(uid), (String)"\u67e5\u8be2\u6210\u529f");
        }
        return CommonResult.noData();
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237id\u67e5\u8be2\u6743\u9650")
    @GetMapping(value={"queryPermissionByUID"})
    public CommonResult queryPermissionByUID(@RequestParam(value="uid") Integer uid) {
        List<SysPermissionEntity> sysPermissionEntities = this.iSysUserEntityService.queryPermissionByUID(uid);
        if (sysPermissionEntities.size() > 0 && sysPermissionEntities.get(0) != null) {
            return CommonResult.success(sysPermissionEntities, (String)"\u67e5\u8be2\u6210\u529f");
        }
        return CommonResult.noData();
    }
}

