/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tuoren.common.api.CommonResult;
import com.tuoren.common.api.IErrorCode;
import com.tuoren.common.api.ResultCode;
import com.tuoren.web.layer.entity.BusAnalgesicScoreEntity;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.entity.BusSolutionEntity;
import com.tuoren.web.layer.mapper.BusAnalgesicScoreMapper;
import com.tuoren.web.layer.mapper.BusPatientMapper;
import com.tuoren.web.layer.mapper.BusPumpMapper;
import com.tuoren.web.layer.mapper.BusSolutionMapper;
import com.tuoren.web.layer.service.IBusAnalgesicScoreService;
import com.tuoren.web.layer.vo.AnalgesicScoreParam;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BusAnalgesicScoreServiceImpl
extends ServiceImpl<BusAnalgesicScoreMapper, BusAnalgesicScoreEntity>
implements IBusAnalgesicScoreService {
    @Autowired
    private BusPatientMapper busPatinetMapper;
    @Autowired
    private BusPumpMapper busPumpMapper;
    @Autowired
    private BusSolutionMapper busSolutionMapper;

    @Override
    @Transactional
    public CommonResult<Object> analgesicScoreRabbitHandle(BusAnalgesicScoreEntity record) {
        this.save(record);
        QueryWrapper patientWrapper = new QueryWrapper();
        patientWrapper.eq((Object)"hospital_code", (Object)record.getHospitalCode());
        patientWrapper.eq((Object)"patient_code", (Object)record.getPatientCode());
        BusPatientEntity patient = (BusPatientEntity)this.busPatinetMapper.selectOne((Wrapper)patientWrapper);
        if (patient == null) {
            return CommonResult.failed((IErrorCode)ResultCode.NOPATIENT);
        }
        QueryWrapper pumpWrapper = new QueryWrapper();
        pumpWrapper.eq((Object)"pump_code", (Object)record.getPumpCode());
        BusPumpEntity pump = (BusPumpEntity)this.busPumpMapper.selectOne((Wrapper)pumpWrapper);
        if (pump == null) {
            return CommonResult.failed((IErrorCode)ResultCode.NOPUMP);
        }
        BusSolutionEntity solution = new BusSolutionEntity();
        BeanUtils.copyProperties((Object)pump, (Object)solution);
        solution.setAnalgesicScoreId(record.getId() + "");
        solution.setAge(patient.getAge());
        solution.setSex(patient.getSex());
        solution.setWeight(patient.getWeight());
        solution.setOperationName(patient.getOperationName());
        solution.setAsa(patient.getAsa());
        solution.setEasyMode(patient.getEasyMode());
        solution.setAnesthesiaMode(patient.getAnesthesiaMode());
        solution.setFormula(patient.getFormula());
        this.busSolutionMapper.insert(solution);
        return CommonResult.success(null);
    }

    @Override
    public long insertAcqId(BusAnalgesicScoreEntity busAnalgesicScoreEntity) {
        busAnalgesicScoreEntity.setId(System.currentTimeMillis());
        this.save(busAnalgesicScoreEntity);
        return busAnalgesicScoreEntity.getId();
    }

    @Override
    public IPage<BusAnalgesicScoreEntity> queryFuzzyScore(AnalgesicScoreParam analgesicScoreParam) {
        Page iPage = new Page((long)analgesicScoreParam.getPageNo().intValue(), (long)analgesicScoreParam.getPageSize().intValue());
        List<BusAnalgesicScoreEntity> list = ((BusAnalgesicScoreMapper)this.getBaseMapper()).queryFuzzyScore((IPage<BusAnalgesicScoreEntity>)iPage, analgesicScoreParam.getHospitalCode(), analgesicScoreParam.getPatientCode(), analgesicScoreParam.getPumpCode(), analgesicScoreParam.getProductCode(), analgesicScoreParam.getCreator());
        iPage.setRecords(list);
        return iPage;
    }
}

