/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.netty;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tuoren.common.utils.enums.LogType;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.entity.BusReceiveRecordEntity;
import com.tuoren.web.layer.entity.SysBreathEntity;
import com.tuoren.web.layer.service.IBusPatientService;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.service.IBusReceiveRecordService;
import com.tuoren.web.layer.service.ISysBreathService;
import com.tuoren.web.push.PushInfo;
import com.tuoren.web.utils.ConverterUtils;
import com.tuoren.web.utils.DataUtils;
import com.tuoren.web.utils.DateFormatUtils;
import com.tuoren.web.utils.LogUtils;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PumpRecvSerivce {
    private static final Logger log = LoggerFactory.getLogger(PumpRecvSerivce.class);
    @Autowired
    public IBusPumpService iPumpService;
    @Autowired
    public IBusPatientService iPatientInfoService;
    @Autowired
    public IBusReceiveRecordService iReceiveRecordService;
    @Autowired
    public ISysBreathService iSysBreathService;
    @Autowired
    public RabbitTemplate rabbitTemplate;
    @Autowired
    private PushInfo pushInfo;
    private static PumpRecvSerivce pumpRecvSerivce;

    @PostConstruct
    public void init() {
        pumpRecvSerivce = this;
        PumpRecvSerivce.pumpRecvSerivce.iPumpService = this.iPumpService;
        PumpRecvSerivce.pumpRecvSerivce.iPatientInfoService = this.iPatientInfoService;
        PumpRecvSerivce.pumpRecvSerivce.iReceiveRecordService = this.iReceiveRecordService;
    }

    public String saveOrUpdate(String content) throws Exception {
        String selectContent = "";
        try {
            selectContent = content.length() > 36 ? DataUtils.getLongContent(content).toJSONString() : DataUtils.getShortContent(content).toJSONString();
            Boolean isShortData = content.length() <= 36;
            log.info("selectContent : >>>>>>>>>>>>>>>>{}", (Object)selectContent);
            LogUtils.save(LogType.Netty, selectContent);
            Map<String, String> map = this.saveReceiveRecord(selectContent);
            String pumpCode = map.get("pumpCode");
            String hospitalCode = map.get("hospitalCode");
            BusPumpEntity pumpEntity = this.savePump(selectContent, pumpCode, hospitalCode, isShortData);
            this.sendInfo(pumpEntity, hospitalCode);
            String productCode = pumpEntity.getProductCode();
            this.pushInfo.pushErrorInfo(pumpEntity.getStateFlag(), pumpEntity.getBufState9(), pumpCode, productCode);
        }
        catch (NullPointerException e) {
            log.error("\u51fa\u73b0\u9519\u8bef: >>>>>> {},{}", (Object)e.getStackTrace()[0], (Object)e.getMessage());
        }
        return selectContent;
    }

    private Map<String, String> saveReceiveRecord(String selectContent) {
        LocalDateTime NOW = LocalDateTime.now();
        QueryWrapper wrapper = new QueryWrapper();
        BusReceiveRecordEntity receiveRecordEntity = (BusReceiveRecordEntity)JSONObject.parseObject((String)selectContent, BusReceiveRecordEntity.class);
        wrapper.eq((Object)"patient_code", (Object)receiveRecordEntity.getPatientCode());
        wrapper.eq((Object)"product_code", (Object)receiveRecordEntity.getProductCode());
        BusPatientEntity patientInfoEntity = (BusPatientEntity)PumpRecvSerivce.pumpRecvSerivce.iPatientInfoService.getOne((Wrapper)wrapper);
        String pumpCode = patientInfoEntity.getPumpCode();
        String hospitalCode = patientInfoEntity.getHospitalCode();
        receiveRecordEntity.setLastUploadTime(NOW);
        receiveRecordEntity.setPumpCode(pumpCode);
        receiveRecordEntity.setHospitalCode(hospitalCode);
        PumpRecvSerivce.pumpRecvSerivce.iReceiveRecordService.save(receiveRecordEntity);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pumpCode", pumpCode);
        map.put("hospitalCode", hospitalCode);
        return map;
    }

    private BusPumpEntity savePump(String selectContent, String pumpCode, String hospitalCode, Boolean isShortData) {
        BusPumpEntity pumpEntity = (BusPumpEntity)JSONObject.parseObject((String)selectContent, BusPumpEntity.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"pump_code", (Object)pumpCode);
        try {
            BusPumpEntity pumpEntityOld = (BusPumpEntity)PumpRecvSerivce.pumpRecvSerivce.iPumpService.getOne((Wrapper)wrapper);
            if (pumpEntityOld != null && pumpEntity.getProductCode().equals("3")) {
                if (pumpEntity.getContinueQuantity().equals(pumpEntity.getUpperLimit()) && pumpEntityOld.getBufState9() == 1) {
                    pumpEntity.setBufState9(1);
                } else if (pumpEntity.getContinueQuantity().equals(pumpEntity.getUpperLimit())) {
                    pumpEntity.setBufState9(2);
                } else if (pumpEntity.getContinueQuantity().compareTo(pumpEntityOld.getContinueQuantity()) > 0) {
                    pumpEntity.setBufState9(3);
                } else if (pumpEntity.getContinueQuantity().compareTo(pumpEntityOld.getContinueQuantity()) < 0) {
                    pumpEntity.setBufState9(4);
                }
            } else {
                pumpEntity.setBufState9(0);
            }
            if (isShortData.booleanValue()) {
                pumpEntity.setStartTime(DateFormatUtils.format(DateUtil.now()));
                pumpEntity.setNoSignal(0);
            }
            pumpEntity.setLastUploadTime(DateFormatUtils.format(DateUtil.now()));
            pumpEntity.setPumpCode(pumpCode);
            pumpEntity.setHospitalCode(hospitalCode);
            pumpEntity.setIsRemove(true);
            PumpRecvSerivce.pumpRecvSerivce.iPumpService.saveOrUpdate(pumpEntity);
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef: >>>>>> {}", (Object)e.getMessage());
        }
        return pumpEntity;
    }

    private void sendInfo(BusPumpEntity pumpEntity, String hospitalCode) throws Exception {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("tableName", (Object)"Pump");
            jsonObject.put("operation", (Object)0);
            jsonObject.put("data", JSON.toJSON((Object)pumpEntity));
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"code", (Object)hospitalCode);
            SysBreathEntity sysBreathEntity = (SysBreathEntity)PumpRecvSerivce.pumpRecvSerivce.iSysBreathService.getOne((Wrapper)wrapper);
            if (sysBreathEntity.getFlagOnline().equals("1")) {
                JSON convert = ConverterUtils.convert(jsonObject, BusPumpEntity.class, ConverterUtils.ConverterType.Cloud2PC);
                this.rabbitTemplate.convertAndSend("hospital." + hospitalCode, (Object)DataUtils.stringToByte(convert), new CorrelationData(convert.toJSONString()));
                LogUtils.save(LogType.MqInfo, convert);
            }
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef: >>>>>> {}", (Object)e.getMessage());
        }
    }
}

