/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.shiro;

import com.tuoren.common.shiro.ShiroFilter;
import com.tuoren.common.shiro.ShiroSessionIdGenerator;
import com.tuoren.common.shiro.ShiroSessionManager;
import com.tuoren.web.shiro.realm.UserRealm;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.crazycake.shiro.IRedisManager;
import org.crazycake.shiro.RedisCacheManager;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSessionDAO;
import org.crazycake.shiro.serializer.ObjectSerializer;
import org.crazycake.shiro.serializer.RedisSerializer;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration
@ConditionalOnClass(value={SecurityManager.class})
@ConfigurationProperties(prefix="shiro")
public class ShiroConfig {
    private static final String SHIRO_FILTER = "shiroFilter";
    private static final String CACHE_KEY = "shiro:cache:";
    private static final String SESSION_KEY = "shiro:session:";
    private static final int EXPIRE = 36000;
    private String hashAlgorithmName = "md5";
    private int hashIterations = 2;
    private String loginUrl = "/index.html";
    private String[] anonUrls;
    private String logOutUrl;
    private String[] authcUlrs;
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.password}")
    private String password;

    @Bean(value={"credentialsMatcher"})
    public HashedCredentialsMatcher hashedCredentialsMatcher() {
        HashedCredentialsMatcher credentialsMatcher = new HashedCredentialsMatcher();
        credentialsMatcher.setHashAlgorithmName(this.hashAlgorithmName);
        credentialsMatcher.setHashIterations(this.hashIterations);
        return credentialsMatcher;
    }

    @Bean(value={"userRealm"})
    public UserRealm userRealm(CredentialsMatcher credentialsMatcher) {
        UserRealm userRealm = new UserRealm();
        userRealm.setCredentialsMatcher(credentialsMatcher);
        return userRealm;
    }

    @Bean(value={"securityManager"})
    public SecurityManager securityManager(UserRealm userRealm) {
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setSessionManager(this.sessionManager());
        securityManager.setCacheManager((CacheManager)this.cacheManager());
        securityManager.setRealm((Realm)userRealm);
        return securityManager;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilterFactoryBean(SecurityManager securityManager) {
        ShiroFilterFactoryBean factoryBean = new ShiroFilterFactoryBean();
        factoryBean.setSecurityManager(securityManager);
        factoryBean.setLoginUrl(this.loginUrl);
        HashMap<String, String> filterChainDefinitionMap = new HashMap<String, String>();
        if (this.anonUrls != null && this.anonUrls.length > 0) {
            for (String anon : this.anonUrls) {
                filterChainDefinitionMap.put(anon, "anon");
            }
        }
        if (null != this.logOutUrl) {
            filterChainDefinitionMap.put(this.logOutUrl, "logout");
        }
        if (this.authcUlrs != null && this.authcUlrs.length > 0) {
            for (String authc : this.authcUlrs) {
                filterChainDefinitionMap.put(authc, "authc");
            }
        }
        Map filters = factoryBean.getFilters();
        filters.put("authc", new ShiroFilter());
        factoryBean.setFilters(filters);
        factoryBean.setFilterChainDefinitionMap(filterChainDefinitionMap);
        return factoryBean;
    }

    @Bean
    public FilterRegistrationBean<DelegatingFilterProxy> delegatingFilterProxy() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        DelegatingFilterProxy proxy = new DelegatingFilterProxy();
        proxy.setTargetFilterLifecycle(true);
        proxy.setTargetBeanName(SHIRO_FILTER);
        filterRegistrationBean.setFilter((Filter)proxy);
        return filterRegistrationBean;
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor = new AuthorizationAttributeSourceAdvisor();
        authorizationAttributeSourceAdvisor.setSecurityManager(securityManager);
        return authorizationAttributeSourceAdvisor;
    }

    @Bean
    public DefaultAdvisorAutoProxyCreator getDefaultAdvisorAutoProxyCreator() {
        DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator = new DefaultAdvisorAutoProxyCreator();
        advisorAutoProxyCreator.setProxyTargetClass(true);
        return advisorAutoProxyCreator;
    }

    @Bean
    public RedisManager redisManager() {
        RedisManager redisManager = new RedisManager();
        redisManager.setHost(this.host);
        redisManager.setPort(this.port);
        redisManager.setTimeout(this.timeout);
        redisManager.setPassword(this.password);
        return redisManager;
    }

    @Bean
    public RedisCacheManager cacheManager() {
        RedisCacheManager redisCacheManager = new RedisCacheManager();
        redisCacheManager.setRedisManager((IRedisManager)this.redisManager());
        redisCacheManager.setKeyPrefix(CACHE_KEY);
        redisCacheManager.setPrincipalIdFieldName("users");
        return redisCacheManager;
    }

    @Bean
    public ShiroSessionIdGenerator sessionIdGenerator() {
        return new ShiroSessionIdGenerator();
    }

    @Bean
    public RedisSessionDAO redisSessionDAO() {
        RedisSessionDAO redisSessionDAO = new RedisSessionDAO();
        redisSessionDAO.setRedisManager((IRedisManager)this.redisManager());
        redisSessionDAO.setSessionIdGenerator((SessionIdGenerator)this.sessionIdGenerator());
        redisSessionDAO.setValueSerializer((RedisSerializer)new ObjectSerializer());
        redisSessionDAO.setKeyPrefix(SESSION_KEY);
        redisSessionDAO.setExpire(36000);
        return redisSessionDAO;
    }

    @Bean
    public SessionManager sessionManager() {
        ShiroSessionManager shiroSessionManager = new ShiroSessionManager();
        shiroSessionManager.setSessionDAO((SessionDAO)this.redisSessionDAO());
        return shiroSessionManager;
    }
}

