/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.shiro.utils;

import com.tuoren.common.redis.RedisService;
import com.tuoren.common.utils.SpringUtil;
import com.tuoren.web.shiro.utils.ActiverUserUtils;
import java.util.Collection;
import java.util.Objects;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.LogoutAware;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.crazycake.shiro.RedisSessionDAO;

public class ShiroUtils
extends ActiverUserUtils {
    private static RedisSessionDAO redisSessionDAO = (RedisSessionDAO)SpringUtil.getBean(RedisSessionDAO.class);
    private static RedisService redisService = (RedisService)SpringUtil.getBean(RedisService.class);

    private ShiroUtils() {
    }

    public static Session getSession() {
        return SecurityUtils.getSubject().getSession();
    }

    public static void logout() {
        SecurityUtils.getSubject().logout();
    }

    public static ActiverUserUtils getUserInfo() {
        ActiverUserUtils activerUserUtils = (ActiverUserUtils)SecurityUtils.getSubject().getPrincipal();
        return activerUserUtils;
    }

    public static void deleteCache(String usercode, boolean isRemoveSession) {
        Session session = null;
        Collection sessions = redisSessionDAO.getActiveSessions();
        Object attribute = null;
        for (Session sessionInfo : sessions) {
            attribute = sessionInfo.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
            if (attribute == null) continue;
            System.out.println(((SimplePrincipalCollection)attribute).getPrimaryPrincipal());
            ActiverUserUtils activerUserUtils = (ActiverUserUtils)((SimplePrincipalCollection)attribute).getPrimaryPrincipal();
            if (activerUserUtils == null || !Objects.equals(activerUserUtils.getUsers().getUserCode(), usercode)) continue;
            session = sessionInfo;
            break;
        }
        if (session == null || attribute == null) {
            return;
        }
        if (isRemoveSession) {
            redisService.remove("portal:user:" + session.getId());
            redisSessionDAO.delete(session);
        }
        DefaultWebSecurityManager securityManager = (DefaultWebSecurityManager)SecurityUtils.getSecurityManager();
        Authenticator authc = securityManager.getAuthenticator();
        ((LogoutAware)authc).onLogout((PrincipalCollection)((SimplePrincipalCollection)attribute));
    }
}

