/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.job;

import com.rabbitmq.http.client.Client;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.tuoren.web.layer.service.IBusHospitalService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class RemoveInvalidQueueJob {
    private static final Logger log = LoggerFactory.getLogger(RemoveInvalidQueueJob.class);
    final int port = 15672;
    @Autowired
    RabbitProperties rabbitProperties;
    @Autowired
    IBusHospitalService busHospitalService;
    Client client = null;

    public boolean init() {
        try {
            this.client = new Client("http://" + this.rabbitProperties.getHost() + ":" + 15672 + "/api", this.rabbitProperties.getUsername(), this.rabbitProperties.getPassword());
            return true;
        }
        catch (MalformedURLException e) {
            log.error("RemoveInvalidQueueJob.getRemoteQueues come with a MalformedURLException,{}", (Object)e.getMessage());
        }
        catch (URISyntaxException e) {
            log.error("RemoveInvalidQueueJob.getRemoteQueues come with a URISyntaxException,{}", (Object)e.getMessage());
        }
        return false;
    }

    @Scheduled(cron="0 0 2 * * ? ")
    public void removeInvalidQueue() {
        if (!this.init()) {
            return;
        }
        List<String> localQueues = this.busHospitalService.queryHospitalCodes();
        List<QueueInfo> remoteQueues = this.getRemoteQueues();
        if (remoteQueues == null) {
            return;
        }
        remoteQueues.forEach(queueInfo -> {
            String name = queueInfo.getName();
            if (!this.isValid(name)) {
                this.deleteRemoteQueue(queueInfo.getVhost(), queueInfo.getName());
                return;
            }
            String hospitalCode = name.split("\\.")[1];
            if (!localQueues.contains(hospitalCode)) {
                this.deleteRemoteQueue(queueInfo.getVhost(), queueInfo.getName());
            }
        });
    }

    public boolean isValid(String queueName) {
        if (queueName.startsWith("hospital")) {
            String[] split = queueName.split("\\.");
            return split.length == 2;
        }
        return "cloud.breath".equals(queueName) || "cloud.analgesicScore".equals(queueName) || "cloud.config".equals(queueName) || "cloud.hospital".equals(queueName) || "cloud.patient".equals(queueName) || "cloud.pump".equals(queueName);
    }

    public List<QueueInfo> getRemoteQueues() {
        return this.client.getQueues();
    }

    public void deleteRemoteQueue(String hostName, String queueName) {
        this.client.deleteQueue(hostName, queueName);
    }

    public int getPort() {
        return this.port;
    }

    public RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public IBusHospitalService getBusHospitalService() {
        return this.busHospitalService;
    }

    public Client getClient() {
        return this.client;
    }

    public void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    public void setBusHospitalService(IBusHospitalService busHospitalService) {
        this.busHospitalService = busHospitalService;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveInvalidQueueJob)) {
            return false;
        }
        RemoveInvalidQueueJob other = (RemoveInvalidQueueJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        RabbitProperties this$rabbitProperties = this.getRabbitProperties();
        RabbitProperties other$rabbitProperties = other.getRabbitProperties();
        if (this$rabbitProperties == null ? other$rabbitProperties != null : !this$rabbitProperties.equals(other$rabbitProperties)) {
            return false;
        }
        IBusHospitalService this$busHospitalService = this.getBusHospitalService();
        IBusHospitalService other$busHospitalService = other.getBusHospitalService();
        if (this$busHospitalService == null ? other$busHospitalService != null : !this$busHospitalService.equals(other$busHospitalService)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoveInvalidQueueJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        RabbitProperties $rabbitProperties = this.getRabbitProperties();
        result = result * 59 + ($rabbitProperties == null ? 43 : $rabbitProperties.hashCode());
        IBusHospitalService $busHospitalService = this.getBusHospitalService();
        result = result * 59 + ($busHospitalService == null ? 43 : $busHospitalService.hashCode());
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "RemoveInvalidQueueJob(port=" + this.getPort() + ", rabbitProperties=" + this.getRabbitProperties() + ", busHospitalService=" + this.getBusHospitalService() + ", client=" + this.getClient() + ")";
    }
}

