/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.netty.handler.decoder;

import cn.hutool.core.date.DateUtil;
import com.google.common.util.concurrent.RateLimiter;
import com.tuoren.web.netty.enums.BanType;
import com.tuoren.web.netty.handler.decoder.AbstarctPumpMessageDecoder;
import com.tuoren.web.netty.param.PipeLineDO;
import com.tuoren.web.utils.NettyUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;

public class LimitAndPumpMessageDecoder
extends AbstarctPumpMessageDecoder {
    @Override
    boolean exceedLimit(Channel channel, ByteBuf in) {
        PipeLineDO pipeLineDo = (PipeLineDO)NettyUtils.getAttribute(channel);
        if ((long)in.readableBytes() > 483L) {
            pipeLineDo.setScore(pipeLineDo.getScore() + (long)BanType.TooLargeData.getScore());
            pipeLineDo.getBanCauses().add(this.getCause(BanType.TooLargeData));
            return true;
        }
        return false;
    }

    @Override
    void remarkVaildData(Channel channel) {
        PipeLineDO pipeLineDo = (PipeLineDO)NettyUtils.getAttribute(channel);
        pipeLineDo.setScore(pipeLineDo.getScore() + (long)BanType.InvalidData.getScore());
        pipeLineDo.getBanCauses().add(this.getCause(BanType.InvalidData));
    }

    @Override
    boolean tryAcquireToken(Channel channel, int dataLen) {
        PipeLineDO pipeLineDo = (PipeLineDO)NettyUtils.getAttribute(channel);
        RateLimiter rateLimiter = pipeLineDo.getRateLimiter();
        if (!rateLimiter.tryAcquire(dataLen)) {
            pipeLineDo.setScore(pipeLineDo.getScore() + (long)BanType.TooFrequent.getScore());
            pipeLineDo.getBanCauses().add(this.getCause(BanType.TooFrequent));
            return false;
        }
        return true;
    }

    private String getCause(BanType banType) {
        return DateUtil.now() + ":" + banType.getName();
    }
}

