/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.rabbit.config;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.tuoren.common.redis.RedisService;
import com.tuoren.common.utils.enums.LogType;
import com.tuoren.web.utils.LogUtils;
import com.tuoren.web.utils.enums.BusServiceEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitTemplateConfig {
    private static final Logger log;
    private static final ConcurrentHashMap<String, Long> map;
    private static final long RETRY_MAX = 3L;
    private static Map<Integer, BusServiceEnum> serviceEnumMap;
    @Autowired
    public RedisService redisService;

    public RabbitTemplate simpleRabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate();
        rabbitTemplate.setConnectionFactory(connectionFactory);
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setConfirmCallback(new RabbitTemplate.ConfirmCallback(){

            public void confirm(CorrelationData correlationData, boolean ack, String cause) {
                String id = correlationData.getId();
                JSONObject jsonObject = JSONUtil.parseObj((String)id);
                System.out.println(id);
                if (!ack) {
                    log.error("\u5b58\u5165\u6570\u636e\u5e93\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b {}", (Object)id);
                    LogUtils.save(LogType.MqFail, jsonObject);
                    log.error("\u6d88\u606f\u53d1\u9001\u5f02\u5e38!");
                    System.out.println(correlationData.getReturnedMessage());
                } else {
                    log.info("\u53d1\u9001\u8005\u5df2\u7ecf\u6536\u5230\u786e\u8ba4\uff0ccorrelationData={} ,ack={}, cause={}", new Object[]{correlationData, ack, cause});
                }
            }
        });
        rabbitTemplate.setReturnCallback(new RabbitTemplate.ReturnCallback(){

            public void returnedMessage(Message message, int replyCode, String replyText, String exchange, String routingKey) {
                log.info("returnedMessage ===> replyCode={} ,replyText={} ,exchange={} ,routingKey={}", new Object[]{replyCode, replyText, exchange, routingKey});
            }
        });
        rabbitTemplate.addAfterReceivePostProcessors(new MessagePostProcessor[]{message -> message});
        rabbitTemplate.addBeforePublishPostProcessors(new MessagePostProcessor[0]);
        return rabbitTemplate;
    }

    static {
        BusServiceEnum[] serviceEnums;
        log = LoggerFactory.getLogger(RabbitTemplateConfig.class);
        map = new ConcurrentHashMap();
        serviceEnumMap = new HashMap<Integer, BusServiceEnum>();
        for (BusServiceEnum serviceEnum : serviceEnums = BusServiceEnum.values()) {
            serviceEnumMap.put(serviceEnum.getId(), serviceEnum);
        }
    }
}

