/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.shiro.realm;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tuoren.common.utils.ConstastUtils;
import com.tuoren.common.utils.WebUtils;
import com.tuoren.web.layer.entity.SysPermissionEntity;
import com.tuoren.web.layer.entity.SysRoleEntity;
import com.tuoren.web.layer.entity.SysUserEntity;
import com.tuoren.web.layer.service.ISysPermissionService;
import com.tuoren.web.layer.service.ISysRoleService;
import com.tuoren.web.layer.service.ISysUserService;
import com.tuoren.web.shiro.utils.ActiverUserUtils;
import com.tuoren.web.shiro.utils.ShiroUtils;
import com.tuoren.web.utils.DateFormatUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class UserRealm
extends AuthorizingRealm {
    @Autowired
    @Lazy
    private ISysUserService userService;
    @Autowired
    @Lazy
    private ISysRoleService iSysRoleService;
    @Autowired
    @Lazy
    private ISysPermissionService iSysPermissionService;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo();
        ActiverUserUtils activerUser = (ActiverUserUtils)principalCollection.getPrimaryPrincipal();
        SysUserEntity user = activerUser.getUsers();
        Integer userId = user.getId();
        Integer userType = user.getType();
        HashSet<String> rolesSet = new HashSet<String>();
        HashSet<String> permsSet = new HashSet<String>();
        List<SysRoleEntity> sysRoleEntityList = this.iSysRoleService.querySysRoleByUserId(userId);
        if (userType.equals(ConstastUtils.USER_TYPE_SUPER)) {
            permsSet.add("*:*");
            authorizationInfo.setStringPermissions(permsSet);
        } else {
            for (SysRoleEntity sysRoleEntity : sysRoleEntityList) {
                rolesSet.add(sysRoleEntity.getName());
                List<SysPermissionEntity> sysPermissionEntityList = this.iSysPermissionService.querySyPermissionByRoleId(sysRoleEntity.getId());
                for (SysPermissionEntity sysPermissionEntity : sysPermissionEntityList) {
                    permsSet.add(sysPermissionEntity.getPerms());
                }
            }
            authorizationInfo.setStringPermissions(permsSet);
        }
        authorizationInfo.setRoles(rolesSet);
        return authorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String userCode = (String)token.getPrincipal();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        SysUserEntity userEntity = new SysUserEntity();
        userEntity.setLoginTime(DateFormatUtils.format(DateUtil.now()));
        userEntity.setUserCode(userCode);
        this.userService.updateById(userEntity);
        SysUserEntity user = (SysUserEntity)this.userService.getOne((Wrapper)queryWrapper);
        if (user == null || !user.getState().booleanValue()) {
            throw new AuthenticationException();
        }
        if (null != user) {
            ActiverUserUtils activerUser = new ActiverUserUtils();
            activerUser.setUsers(user);
            Integer userId = activerUser.getUsers().getId();
            List<String> userRoles = this.iSysRoleService.queryUserRoleIdsByUid(userId);
            QueryWrapper qwr = new QueryWrapper();
            List rolelist = new ArrayList();
            if (userRoles.size() > 0) {
                qwr.in((Object)"id", userRoles);
                rolelist = this.iSysRoleService.list((Wrapper)qwr);
            }
            ArrayList<String> roles = new ArrayList<String>();
            for (SysRoleEntity r : rolelist) {
                roles.add(r.getName());
            }
            activerUser.setRoles(roles);
            activerUser.setDevice(WebUtils.getUserAgent());
            ByteSource credentialsSalt = ByteSource.Util.bytes((String)user.getSalt());
            SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)activerUser, (Object)user.getPassword(), credentialsSalt, this.getName());
            System.out.println("UserCode: " + userCode);
            System.out.println("\u9a8c\u8bc1\u6210\u529f\u5f00\u59cb\u8e22\u4eba(\u6e05\u9664\u7f13\u5b58\u548cSession)");
            ShiroUtils.deleteCache(userCode, true);
            return info;
        }
        return null;
    }
}

