/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.job;

import cn.hutool.core.date.DateUtil;
import com.tuoren.common.config.MvcConfig;
import com.tuoren.common.entity.MvcEntity;
import com.tuoren.web.layer.entity.SysInterfaceFlowStatisticsEntity;
import com.tuoren.web.layer.service.ISysInterfaceFlowStatisticsService;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class InterfaceFlowStatisticsJob {
    private static final Logger log = LoggerFactory.getLogger(InterfaceFlowStatisticsJob.class);
    ISysInterfaceFlowStatisticsService statisticsService;

    @Autowired
    public InterfaceFlowStatisticsJob(ISysInterfaceFlowStatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 58 23 * * ? ")
    public void logStatics() {
        MvcConfig.LOCK.writeLock().lock();
        try {
            Map urlmap = MvcConfig.URLMAP;
            LinkedList list = new LinkedList();
            String statisticsTime = DateUtil.today();
            urlmap.forEach((K, V) -> {
                SysInterfaceFlowStatisticsEntity statisticsEntity = new SysInterfaceFlowStatisticsEntity((MvcEntity)K);
                int count = V.getAndSet(0);
                if (count == 0) {
                    return;
                }
                statisticsEntity.setCount(count);
                statisticsEntity.setStatisticsTime(statisticsTime);
                list.add(statisticsEntity);
            });
            this.statisticsService.saveBatch(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MvcConfig.LOCK.writeLock().unlock();
        }
    }

    public ISysInterfaceFlowStatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    public void setStatisticsService(ISysInterfaceFlowStatisticsService statisticsService) {
        this.statisticsService = statisticsService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InterfaceFlowStatisticsJob)) {
            return false;
        }
        InterfaceFlowStatisticsJob other = (InterfaceFlowStatisticsJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ISysInterfaceFlowStatisticsService this$statisticsService = this.getStatisticsService();
        ISysInterfaceFlowStatisticsService other$statisticsService = other.getStatisticsService();
        return !(this$statisticsService == null ? other$statisticsService != null : !this$statisticsService.equals(other$statisticsService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InterfaceFlowStatisticsJob;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ISysInterfaceFlowStatisticsService $statisticsService = this.getStatisticsService();
        result = result * 59 + ($statisticsService == null ? 43 : $statisticsService.hashCode());
        return result;
    }

    public String toString() {
        return "InterfaceFlowStatisticsJob(statisticsService=" + this.getStatisticsService() + ")";
    }
}

