/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.job;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.service.ISysConfigService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class SysConfigJob {
    private static final Logger log = LoggerFactory.getLogger(SysConfigJob.class);
    private static final int pageSize = 500;
    private static SysConfigJob sysConfigJob;
    @Autowired
    public ISysConfigService iSystemConfigEntityService;
    @Autowired
    public IBusPumpService iBusPumpService;

    @PostConstruct
    public void init() {
        sysConfigJob = this;
        SysConfigJob.sysConfigJob.iSystemConfigEntityService = this.iSystemConfigEntityService;
    }

    @Scheduled(cron="0 0/2 * * * *")
    public void updatePumpList() {
        int count = this.iBusPumpService.count();
        int page = (int)Math.ceil(count / 500);
        Page pumpEntityPage = new Page();
        for (int i = 0; i <= page; ++i) {
            pumpEntityPage.setSize(500L);
            pumpEntityPage.setPages((long)page);
            List records = this.iBusPumpService.page((IPage)pumpEntityPage).getRecords();
            this.getFilterList(records);
            this.iBusPumpService.saveOrUpdateBatch(records);
        }
    }

    public void getFilterList(List<BusPumpEntity> list) {
        for (BusPumpEntity v : list) {
            try {
                String dateStr = v.getLastUploadTime().toString().replaceAll("T", " ");
                DateTime date = DateUtil.parse((String)dateStr);
                DateTime now = DateTime.now();
                long betweenMin = DateUtil.between((Date)date, (Date)now, (DateUnit)DateUnit.MINUTE);
                Map<String, String> map = SysConfigJob.sysConfigJob.iSystemConfigEntityService.querySysConfigByHospitalMap(v.getHospitalCode());
                boolean IsAutoUndo = Boolean.parseBoolean(map.get("IsAutoUndo"));
                String OutServiceSpan = StrUtil.isNotEmpty((CharSequence)map.get("OutServiceSpan")) ? map.get("OutServiceSpan") : "60";
                String AutoOutSpan = StrUtil.isNotEmpty((CharSequence)map.get("AutoOutSpan")) ? map.get("AutoOutSpan") : "3";
                String OffSpan = StrUtil.isNotEmpty((CharSequence)map.get("OffSpan")) ? map.get("OffSpan") : "5";
                long OutSpanAndOutServiceSpan = Long.parseLong(OutServiceSpan) + Long.parseLong(AutoOutSpan);
                if (v.getRunState() == null) continue;
                if (IsAutoUndo) {
                    if (v.getRunState() == 0 && betweenMin >= Long.parseLong(OffSpan) || v.getRunState() != 0 && betweenMin >= OutSpanAndOutServiceSpan) {
                        v.setIsRemove(false);
                    } else {
                        v.setIsRemove(true);
                    }
                }
                if (v.getRunState() != 0 && betweenMin >= Long.parseLong(OutServiceSpan)) {
                    v.setNoSignal(1);
                    continue;
                }
                v.setNoSignal(0);
            }
            catch (NullPointerException e) {
                log.error("\u51fa\u73b0\u9519\u8bef: >>>>>> {}", (Object)e.getMessage());
            }
        }
    }
}

