/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import com.alibaba.fastjson.JSON;
import com.tuoren.common.api.CommonResult;
import com.tuoren.common.redis.RedisService;
import com.tuoren.common.utils.AESUtils;
import com.tuoren.common.utils.WebUtils;
import com.tuoren.common.utils.enums.LogType;
import com.tuoren.web.layer.entity.SysUserEntity;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.service.ISysConfigService;
import com.tuoren.web.layer.service.ISysRoleService;
import com.tuoren.web.layer.vo.UserLoginParam;
import com.tuoren.web.push.PushInfo;
import com.tuoren.web.shiro.utils.ActiverUserUtils;
import com.tuoren.web.shiro.utils.ShiroUtils;
import com.tuoren.web.utils.LogUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"LoginController"}, description="\u767b\u5f55")
@RestController
public class BusLoginController {
    private static final Logger log = LoggerFactory.getLogger(BusLoginController.class);
    private final RedisService redisService;
    public final IBusPumpService iBusPumpService;
    public final ISysRoleService iSysRoleService;
    public final ISysConfigService iSysConfigService;
    private PushInfo pushInfo;

    @ApiOperation(value="\u767b\u5f55")
    @PostMapping(value={"/login"})
    public CommonResult login(@RequestBody UserLoginParam userLoginParam) throws Exception {
        Subject subject = SecurityUtils.getSubject();
        String device = WebUtils.getUserAgent();
        String pwd = AESUtils.aesDecrypt((String)userLoginParam.getPassword(), (String)"2550e1be21ba49a1");
        UsernamePasswordToken token = new UsernamePasswordToken(userLoginParam.getUsername(), pwd);
        Serializable tokenId = subject.getSession().getId();
        try {
            subject.login((AuthenticationToken)token);
            ActiverUserUtils activerUser = (ActiverUserUtils)subject.getPrincipal();
            activerUser.setToken(ShiroUtils.getSession().getId().toString());
            activerUser.setDevice(device);
            List<String> role = activerUser.getRoles();
            SysUserEntity acUser = activerUser.getUsers();
            String hospital = acUser.getHospitalCode();
            Map<String, String> map = this.iSysConfigService.querySysConfigByHospitalMap(hospital);
            if (activerUser.getUsers().getType() != 1 && map.isEmpty()) {
                this.redisService.remove("shiro:session:" + (String)((Object)tokenId));
                return CommonResult.failed((String)"\u8be5\u7528\u6237\u533b\u9662\u6ca1\u6709\u8fdb\u884c\u76f8\u5173\u914d\u7f6e\u8bbe\u7f6e,\u65e0\u6cd5\u767b\u5f55");
            }
            this.redisService.set("portal:user:" + activerUser.getToken(), JSON.toJSONString((Object)activerUser));
            this.redisService.expire("portal:user:" + activerUser.getToken(), 36000L);
            this.redisService.expire("shiro:session:" + activerUser.getToken(), 36000L);
            SysUserEntity user = new SysUserEntity();
            user.setUserCode(acUser.getUserCode());
            user.setUserCode(acUser.getName());
            user.setLoginTime(acUser.getLoginTime());
            user.setHospitalCode(acUser.getHospitalCode());
            LogUtils.save(LogType.Login, user);
            return CommonResult.success((Object)activerUser);
        }
        catch (AuthenticationException e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            this.redisService.remove("shiro:session:" + (String)((Object)tokenId));
            return CommonResult.failed((String)"\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef");
        }
    }

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @GetMapping(value={"/logout"})
    public CommonResult logout() {
        ShiroUtils.logout();
        return CommonResult.success((Object)"\u5df2\u9000\u51fa");
    }

    @ApiOperation(value="\u5224\u65ad token \u662f\u5426\u6709\u6548")
    @GetMapping(value={"/isToken"})
    public CommonResult isToken(@RequestParam String token) {
        String sessionRedisToken = "shiro:session:" + token;
        Set sessionKeys = this.redisService.getKeys("shiro:session:login_token_*");
        for (String sk : sessionKeys) {
            if (!sk.equals(sessionRedisToken)) continue;
            return CommonResult.success((Object)true);
        }
        return CommonResult.validateFailed();
    }

    @ApiOperation(value="\u7b80\u5355\u63a8\u9001\u6d4b\u8bd5")
    @GetMapping(value={"/push"})
    public CommonResult push(@RequestParam String pumpCode, String productCode, Integer stateFlag, Integer bufState9) throws Exception {
        try {
            String LUA = "lua/getRedisMixed.lua";
            Set reidsKeys = this.redisService.getKeys("*");
            ArrayList list = new ArrayList(reidsKeys);
            List result = (List)this.redisService.runLua(LUA, List.class, list, new Object[0]);
            ArrayList nameList = new ArrayList();
            if (result.size() < 1) {
                return CommonResult.failed((String)"\u6ca1\u6709\u7528\u6237\u5728\u767b\u5f55\u4e2d");
            }
            for (Object i : result) {
                ActiverUserUtils activerUserUtils = (ActiverUserUtils)JSON.parseObject((String)this.redisService.get(i.toString()), ActiverUserUtils.class);
                SysUserEntity usersEntity = activerUserUtils.getUsers();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (activerUserUtils.getDevice() == null) continue;
                map.put("Device", activerUserUtils.getDevice());
                map.put("PumpCode", pumpCode);
                map.put("Token", activerUserUtils.getToken());
                map.put("UserCode", usersEntity.getUserCode());
                map.put("Hospital", usersEntity.getHospitalCode());
                map.put("LastProduct", usersEntity.getLastProduct());
                map.put("LoginTime", usersEntity.getLoginTime());
                nameList.add(map);
            }
            this.pushInfo.pushErrorInfo(stateFlag, bufState9, pumpCode, productCode);
            return CommonResult.success(nameList, (String)"\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6ca1\u6709\u7528\u6237\u5728\u767b\u5f55\u4e2d");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6240\u6709\u7684redis key, 1 \u6240\u6709 | 2 \u7528\u6237")
    @GetMapping(value={"/delSession"})
    public CommonResult delSession(@RequestParam Integer key) {
        Set portalKeys = this.redisService.getKeys("portal:user:login_token_*");
        Set sessionKeys = this.redisService.getKeys("shiro:session:login_token_*");
        Set redisKeysAll = this.redisService.getKeys("*");
        switch (key) {
            case 1: {
                for (String all : redisKeysAll) {
                    this.redisService.remove(all);
                }
                break;
            }
            case 2: {
                for (String pk : portalKeys) {
                    this.redisService.remove(pk);
                }
                for (String sk : sessionKeys) {
                    this.redisService.remove(sk);
                }
                break;
            }
        }
        return CommonResult.success((Object)"\u5220\u9664\u6210\u529f");
    }

    public BusLoginController(RedisService redisService, IBusPumpService iBusPumpService, ISysRoleService iSysRoleService, ISysConfigService iSysConfigService, PushInfo pushInfo) {
        this.redisService = redisService;
        this.iBusPumpService = iBusPumpService;
        this.iSysRoleService = iSysRoleService;
        this.iSysConfigService = iSysConfigService;
        this.pushInfo = pushInfo;
    }
}

