/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.tuoren.common.api.CommonResult;
import com.tuoren.web.layer.d0.PumpVo;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.entity.SysUserEntity;
import com.tuoren.web.layer.service.IBusPatientService;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.service.ISysUserService;
import com.tuoren.web.layer.vo.PumpParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"BusPumpController"}, description="\u6cf5\u7ba1\u7406(\u91cd\u8981)")
@RestController
@RequestMapping(value={"/bus/pump"})
public class BusPumpController {
    private static final Logger log = LoggerFactory.getLogger(BusPumpController.class);
    @Autowired
    public IBusPumpService iBusPumpEntityService;
    @Autowired
    public ISysUserService iSysUserService;
    @Autowired
    public IBusPatientService iBusPatientService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, BusPumpEntity busPumpEntity) {
        return CommonResult.success(this.iBusPumpEntityService.queryPumpList(pageNo, pageSize, busPumpEntity));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iBusPumpEntityService.getById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public CommonResult insert(@RequestBody BusPumpEntity busPumpEntity) {
        try {
            return CommonResult.success((Object)this.iBusPumpEntityService.save(busPumpEntity), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody BusPumpEntity busPumpEntity) {
        try {
            return CommonResult.success((Object)this.iBusPumpEntityService.updateById(busPumpEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.success((Object)this.iBusPumpEntityService.removeByIds(idList), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u7528\u6237\u81ea\u5b9a\u4e49\u67e5\u8be2,\u6839\u636e\u75c5\u533a/\u5e8a\u53f7/\u4f4f\u9662\u53f7\u7b49\u5339\u914d\u6cf5\u4fe1\u606f")
    @PostMapping(value={"/getPumpListByCustom"})
    public CommonResult selectPumpByCustom(@RequestBody PumpParam pumpParam) {
        QueryWrapper uw = new QueryWrapper();
        uw.eq(StrUtil.isNotBlank((CharSequence)pumpParam.getUserCode()), (Object)"user_code", (Object)pumpParam.getUserCode());
        SysUserEntity usersEntity = (SysUserEntity)this.iSysUserService.getOne((Wrapper)uw);
        pumpParam.setHospitalCode(usersEntity.getHospitalCode());
        IPage<PumpVo> iPage = this.iBusPumpEntityService.queryPumpListByCustom(pumpParam);
        if (iPage.getRecords().size() > 0) {
            return CommonResult.success(iPage);
        }
        return CommonResult.noData();
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5bf9\u5e94\u7684\u5168\u90e8\u6cf5/\u8fd0\u884c\u4e2d\u7684\u6cf5/\u62a5\u8b66\u7684\u6cf5")
    @PostMapping(value={"/getPumpListByUser"})
    public CommonResult selectPumpByUser(@RequestBody PumpParam pumpParam) {
        QueryWrapper uw = new QueryWrapper();
        uw.eq(StrUtil.isNotBlank((CharSequence)pumpParam.getUserCode()), (Object)"user_code", (Object)pumpParam.getUserCode());
        SysUserEntity usersEntity = (SysUserEntity)this.iSysUserService.getOne((Wrapper)uw);
        pumpParam.setPageNo(pumpParam.getPageNo());
        pumpParam.setPageSize(pumpParam.getPageSize());
        pumpParam.setStateFlag(pumpParam.getStateFlag());
        pumpParam.setUpAndDown(pumpParam.getUpAndDown());
        pumpParam.setBufState9(pumpParam.getBufState9());
        pumpParam.setUserCode(pumpParam.getUserCode());
        pumpParam.setRunState(pumpParam.getRunState());
        pumpParam.setProductCode(pumpParam.getProductCode());
        pumpParam.setHospitalCode(usersEntity.getHospitalCode());
        IPage<PumpVo> iPage = this.iBusPumpEntityService.queryPumpListByUser(pumpParam);
        if (iPage.getRecords().size() > 0) {
            return CommonResult.success(iPage);
        }
        return CommonResult.noData();
    }

    @ApiOperation(value="\u83b7\u53d6\u6ce8\u6db2\u4fe1\u606f\u548c\u75c5\u4eba\u4fe1\u606f")
    @PostMapping(value={"/getPumpInfo"})
    public CommonResult getPumpInfo(@RequestBody PumpParam pumpParam) throws Exception {
        try {
            QueryWrapper pie = new QueryWrapper();
            if (!StrUtil.isNotBlank((CharSequence)pumpParam.getPatientId())) {
                return CommonResult.failed((String)"\u8bf7\u8f93\u5165\u60a3\u8005ID");
            }
            pie.eq(StrUtil.isNotBlank((CharSequence)pumpParam.getPatientId()), (Object)"patient_id", (Object)pumpParam.getPatientId());
            BusPatientEntity patientInfoEntity = (BusPatientEntity)this.iBusPatientService.getOne((Wrapper)pie);
            pumpParam.setPatientCode(patientInfoEntity.getPatientCode());
            List<PumpVo> list = this.iBusPumpEntityService.queryPumpInfo(pumpParam);
            if (list.size() > 0) {
                return CommonResult.success((Object)list.get(0));
            }
            return CommonResult.noData();
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed();
        }
    }

    @ApiOperation(value="\u64a4\u6cf5")
    @PostMapping(value={"/removePumpByIds"})
    public CommonResult<Boolean> removePump(@RequestBody List<String> ids) {
        this.iBusPumpEntityService.removePump(ids);
        return CommonResult.success((Object)Boolean.TRUE);
    }
}

