/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.layer.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tuoren.common.api.CommonResult;
import com.tuoren.web.layer.entity.SysConfigEntity;
import com.tuoren.web.layer.service.ISysConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"SysConfigController"}, description="\u533b\u9662\u914d\u7f6e\u7ba1\u7406")
@RestController
@RequestMapping(value={"/sys/config"})
public class SysConfigController {
    private static final Logger log = LoggerFactory.getLogger(SysConfigController.class);
    @Autowired
    public ISysConfigService iSysConfigEntityService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping
    public CommonResult selectAll(Integer pageNo, Integer pageSize, SysConfigEntity sysConfigEntity) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper((Object)sysConfigEntity);
        wrapper.orderByDesc((Object)"gmt_modified");
        return CommonResult.success((Object)this.iSysConfigEntityService.page((IPage)page, (Wrapper)wrapper));
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public CommonResult selectOne(@PathVariable Serializable id) {
        return CommonResult.success((Object)this.iSysConfigEntityService.getById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public CommonResult insert(@RequestBody SysConfigEntity sysConfigEntity) {
        try {
            return CommonResult.success((Object)this.iSysConfigEntityService.save(sysConfigEntity), (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping
    public CommonResult update(@RequestBody SysConfigEntity sysConfigEntity) {
        try {
            return CommonResult.success((Object)this.iSysConfigEntityService.updateById(sysConfigEntity), (String)"\u4fee\u6539\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping
    public CommonResult delete(@RequestParam(value="idList") List<Long> idList) {
        try {
            return CommonResult.success((Object)this.iSysConfigEntityService.removeByIds(idList), (String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u51fa\u73b0\u9519\u8bef, {}", (Object)e.getMessage());
            return CommonResult.failed((String)"\u5220\u9664\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6709\u5173\u533b\u9662\u6570\u636e")
    @PostMapping(value={"/getSystemConfigByHospital"})
    public Map<String, String> getSystemConfigByHospital(@RequestParam String id) {
        return this.iSysConfigEntityService.querySysConfigByHospitalMap(id);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u66f4\u65b0\u6709\u5173\u533b\u9662\u914d\u7f6e")
    @PostMapping(value={"/saveOrUpdateSystemConfig"})
    @RequiresPermissions(value={"bus:config:saveOrUpdate"})
    public CommonResult saveOrUpdateSystemConfig(@RequestBody SysConfigEntity sysConfigEntity) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"hospital_code", (Object)sysConfigEntity.getHospitalCode());
        wrapper.eq((Object)"name", (Object)sysConfigEntity.getName());
        wrapper.orderByDesc((Object)"gmt_modified");
        wrapper.last("limit 1");
        SysConfigEntity one = (SysConfigEntity)this.iSysConfigEntityService.getOne((Wrapper)wrapper);
        if (one == null) {
            return CommonResult.success((Object)this.iSysConfigEntityService.save(sysConfigEntity));
        }
        sysConfigEntity.setId(one.getId());
        return CommonResult.success((Object)this.iSysConfigEntityService.updateById(sysConfigEntity));
    }
}

