/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.netty;

import com.tuoren.common.utils.ConstastUtils;
import com.tuoren.web.netty.NettyServerHandlerInitializer;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private EventLoopGroup Boss = new NioEventLoopGroup();
    private EventLoopGroup Work = new NioEventLoopGroup();
    private Integer port = ConstastUtils.NETTY_PORT;

    public static NettyServer getInstance() {
        return SingletionNettyServer.instance;
    }

    public void pumpStart() {
        ServerBootstrap Bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)Bootstrap.group(this.Boss, this.Work).channel(NioServerSocketChannel.class)).localAddress((SocketAddress)new InetSocketAddress(this.port))).option(ChannelOption.SO_BACKLOG, (Object)65535)).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)AdaptiveRecvByteBufAllocator.DEFAULT).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)new NettyServerHandlerInitializer());
        ChannelFuture future = null;
        try {
            future = Bootstrap.bind().sync();
            if (future.isSuccess()) {
                log.info("\u542f\u52a8 Pump Netty Server, \u7aef\u53e3\u53f7\u4e3a: " + this.port);
            }
        }
        catch (InterruptedException e) {
            log.error("NettyServer.pumpStart(),{}", (Object)e.getMessage());
        }
    }

    @PreDestroy
    public void destory() throws InterruptedException {
        this.Boss.shutdownGracefully().sync();
        this.Work.shutdownGracefully().sync();
        log.info("\u5173\u95edNetty");
    }

    private static class SingletionNettyServer {
        static final NettyServer instance = new NettyServer();

        private SingletionNettyServer() {
        }
    }
}

