/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.push;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tuoren.common.push.Push;
import com.tuoren.common.redis.RedisService;
import com.tuoren.common.utils.DiffTimeUtils;
import com.tuoren.common.utils.SpringUtil;
import com.tuoren.common.utils.enums.LogType;
import com.tuoren.web.layer.d0.PumpVo;
import com.tuoren.web.layer.d0.PushVo;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.service.ISysConfigService;
import com.tuoren.web.layer.vo.PumpParam;
import com.tuoren.web.shiro.utils.ActiverUserUtils;
import com.tuoren.web.utils.LogUtils;
import com.tuoren.web.utils.ThreadPoolExectorUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.crazycake.shiro.RedisSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PushInfo {
    private static final Logger log = LoggerFactory.getLogger(PushInfo.class);
    private final RedisService redisService;
    public final IBusPumpService iBusPumpService;
    public final ISysConfigService iSysConfigService;
    public final RedisSessionDAO redisSessionDAO;
    private static String LUA = "lua/getRedisMixed.lua";
    private static ThreadPoolExecutor threadPool = ThreadPoolExectorUtils.getThreadPool("PushInfo");
    private static final int count = 200;

    public static List<List> createList(List targe, int size) {
        ArrayList<List> listArr = new ArrayList<List>();
        int arrSize = targe.size() % size == 0 ? targe.size() / size : targe.size() / size + 1;
        for (int i = 0; i < arrSize; ++i) {
            ArrayList sub = new ArrayList();
            for (int j = i * size; j <= size * (i + 1) - 1; ++j) {
                if (j > targe.size() - 1) continue;
                sub.add(targe.get(j));
            }
            listArr.add(sub);
        }
        return listArr;
    }

    public void pushErrorInfo(Integer stateFlag, Integer bufState9, String pumpCode, String productCode) throws Exception {
        try {
            if (stateFlag != null && bufState9 != null) {
                if (stateFlag == 4 && bufState9 == 1) {
                    this.push(pumpCode, productCode, 4, 1);
                } else if (stateFlag == 4) {
                    this.push(pumpCode, productCode, 4, null);
                } else if (bufState9 == 1) {
                    this.push(pumpCode, productCode, null, 1);
                }
            }
        }
        catch (Exception e) {
            log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + ": " + e.getMessage());
        }
    }

    public void push(String pumpCode, String productId, Integer stateFlag, Integer bufState9) throws Exception {
        try {
            BusPumpEntity pump;
            Collection activeSessions = this.redisSessionDAO.getActiveSessions();
            PumpParam pumpParam = new PumpParam();
            if (stateFlag != null) {
                pumpParam.setStateFlag(stateFlag);
            }
            if (bufState9 != null) {
                pumpParam.setBufState9(bufState9);
            }
            if (activeSessions.size() >= 1 && (pump = (BusPumpEntity)this.iBusPumpService.getOne((Wrapper)new QueryWrapper().lambda().eq(BusPumpEntity::getPumpCode, (Object)pumpCode))) != null) {
                activeSessions.forEach(session -> ((PushInfo)SpringUtil.getBean(PushInfo.class)).getUserPush((Session)session, pumpCode, productId, pump.getHospitalCode()));
            }
        }
        catch (NullPointerException e) {
            log.error("\u63a8\u9001\u5931\u8d25,{}", (Object)e.getMessage());
            log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + ": " + e.getMessage());
        }
    }

    private List<String> getUserRedisKey() {
        return new ArrayList<String>(this.redisService.getKeys("shiro:session:*"));
    }

    @Async
    public void getUserPush(Session session, String pumpCode, String productId, String hospitalCode) throws NullPointerException {
        try {
            PumpParam pumpParam = new PumpParam();
            if (session instanceof SimpleSession) {
                SimpleSession simpleSession = (SimpleSession)session;
                SimplePrincipalCollection simplePrincipalCollection = (SimplePrincipalCollection)simpleSession.getAttribute((Object)DefaultSubjectContext.PRINCIPALS_SESSION_KEY);
                ActiverUserUtils activerUserUtils = (ActiverUserUtils)simplePrincipalCollection.getPrimaryPrincipal();
                String device = activerUserUtils.getDevice();
                if (device == null || device.equals("")) {
                    return;
                }
                String hospitalId = activerUserUtils.getUsers().getHospitalCode();
                String userCode = activerUserUtils.getUsers().getUserCode();
                if (activerUserUtils.getUsers().getProductCode().contains(productId) && activerUserUtils.getUsers().getHospitalCode().equals(hospitalCode)) {
                    pumpParam.setUserCode(userCode);
                    pumpParam.setHospitalCode(hospitalId);
                    pumpParam.setPumpCode(pumpCode);
                    pumpParam.setProductCode(productId);
                    this.pushUser(pumpParam, device, userCode);
                }
            }
        }
        catch (NullPointerException e) {
            log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + ": " + e.getMessage());
        }
    }

    private void pushUser(PumpParam pumpParam, String device, String user) {
        try {
            List<PumpVo> pumpVoList = this.iBusPumpService.queryPumpWarnListByUser(pumpParam);
            if (pumpVoList.size() < 1) {
                return;
            }
            if (device.equals("Phone")) {
                this.pushDetailData(pumpVoList, user, "30549452", "Phone");
            } else {
                this.pushDetailData(pumpVoList, user, "30537902", "Pad");
            }
        }
        catch (Exception e) {
            log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + ": " + e.getMessage());
        }
    }

    public void pushDetailData(List<PumpVo> list, String userCode, String appKey, String msg) throws Exception {
        DiffTimeUtils diffTimeUtil = new DiffTimeUtils();
        Push push = new Push();
        PushVo pushVo = new PushVo();
        for (PumpVo p : list) {
            try {
                log.info("\u83b7\u53d6\u65f6\u95f4\u770b\u770b\u662f\u5426\u63a8\u9001\uff1a {}", (Object)p.getLastUploadTime());
                log.info("\u6bd4\u5bf9\u65f6\u95f4: {}", (Object)diffTimeUtil.pushTimeDiff(p.getLastUploadTime(), 40));
                if (!diffTimeUtil.pushTimeDiff(p.getLastUploadTime(), 40).booleanValue()) continue;
                pushVo.setName(p.getName());
                pushVo.setPatientCode(p.getPatientCode());
                pushVo.setProductId(p.getProductCode());
                StringBuffer sb = new StringBuffer();
                if (p.getStateFlag() == 4) {
                    sb.append(p.getViewState());
                }
                if (p.getBufState9() == 1) {
                    sb.append(" \u52a0\u6863\u53d7\u9650 ");
                }
                if (p.getNoSignal() == 1) {
                    sb.append(" - \u4e0d\u5728\u670d\u52a1\u533a");
                }
                if (StrUtil.isBlank((CharSequence)sb.toString())) continue;
                pushVo.setAlarm(sb.toString());
                pushVo.setDateTime(LocalDateTime.now());
                pushVo.setUserCode(userCode);
                System.out.println(msg + " : " + JSON.toJSONString((Object)pushVo));
                push.AdvancedPush(userCode, "\u6807\u9898", JSON.toJSONString((Object)pushVo), appKey);
                LogUtils.save(LogType.PushInfo, pushVo);
            }
            catch (InterruptedException e) {
                log.error(Thread.currentThread().getStackTrace()[1].getMethodName() + ": " + e.getMessage());
            }
        }
    }

    public PushInfo(RedisService redisService, IBusPumpService iBusPumpService, ISysConfigService iSysConfigService, RedisSessionDAO redisSessionDAO) {
        this.redisService = redisService;
        this.iBusPumpService = iBusPumpService;
        this.iSysConfigService = iSysConfigService;
        this.redisSessionDAO = redisSessionDAO;
    }
}

