/*
 * Decompiled with CFR 0.152.
 */
package com.tuoren.web.rabbit;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tuoren.common.api.CommonResult;
import com.tuoren.common.api.ResultCode;
import com.tuoren.common.utils.LocalDateTimeUtil;
import com.tuoren.web.layer.entity.BusAnalgesicScoreEntity;
import com.tuoren.web.layer.entity.BusHospitalEntity;
import com.tuoren.web.layer.entity.BusPatientEntity;
import com.tuoren.web.layer.entity.BusPumpEntity;
import com.tuoren.web.layer.entity.SysConfigEntity;
import com.tuoren.web.layer.service.IBusAnalgesicScoreService;
import com.tuoren.web.layer.service.IBusHospitalService;
import com.tuoren.web.layer.service.IBusPatientService;
import com.tuoren.web.layer.service.IBusPumpService;
import com.tuoren.web.layer.service.ISysBreathService;
import com.tuoren.web.layer.service.ISysConfigService;
import com.tuoren.web.push.PushInfo;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.Queue;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

@Component
public class RabbitHandle {
    private static final Logger log = LoggerFactory.getLogger(RabbitHandle.class);
    private final RabbitTemplate rabbitTemplate;
    private final ISysBreathService iSysBreathService;
    private final IBusHospitalService iBusHospitalService;
    private final IBusPatientService iBusPatientService;
    private final IBusPumpService iBusPumpService;
    private final IBusAnalgesicScoreService iBusAnalgesicScoreService;
    private final ISysConfigService iSysConfigService;
    PushInfo pushInfo;

    @RabbitListener(queuesToDeclare={@Queue(value="cloud.breath")})
    public void breathHandle(byte[] bytes) {
        String message = RabbitHandle.byteToString(bytes);
        log.info("======breathHandle======:" + message);
        if (!this.existHospital(message).booleanValue()) {
            return;
        }
        this.iSysBreathService.breahRabbitHandle(message);
    }

    @RabbitListener(queuesToDeclare={@Queue(value="cloud.hospital")})
    public void hospitalHandle(byte[] bytes) {
        String message = RabbitHandle.byteToString(bytes);
        log.info("======hospitalHandle======:" + message);
        BusHospitalEntity record = (BusHospitalEntity)JSONObject.parseObject((String)message, BusHospitalEntity.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"hospital_code", (Object)record.getHospitalCode());
        BusHospitalEntity existHospital = (BusHospitalEntity)this.iBusHospitalService.getOne((Wrapper)wrapper);
        if (existHospital == null) {
            this.iBusHospitalService.save(record);
        } else {
            record.setId(existHospital.getId());
            this.iBusHospitalService.updateById(record);
        }
    }

    @RabbitListener(queuesToDeclare={@Queue(value="cloud.patient")})
    public void patientHandle(byte[] bytes) {
        BusPatientEntity patient;
        String message = RabbitHandle.byteToString(bytes);
        log.info("======patientHandle======:" + message);
        JSONObject data = JSONObject.parseObject((String)message);
        LocalDateTime undoTime = null;
        if (data.get((Object)"undoTime") != null) {
            long time = data.getLong("undoTime");
            undoTime = LocalDateTimeUtil.longToLocalTime((Long)time);
            data.remove((Object)"undoTime");
        }
        if (!this.existHospital((patient = (BusPatientEntity)data.toJavaObject(BusPatientEntity.class)).getHospitalCode()).booleanValue()) {
            return;
        }
        patient.setUndoTime(undoTime);
        this.iBusPatientService.saveOrUpdate(patient);
    }

    @RabbitListener(queuesToDeclare={@Queue(value="cloud.pump")})
    public void pumpHandle(byte[] bytes) throws Exception {
        try {
            long time;
            String message = RabbitHandle.byteToString(bytes);
            log.info("======pumpHandle======:" + message);
            JSONObject data = JSONObject.parseObject((String)message);
            LocalDateTime startTime = null;
            LocalDateTime lastUploadTime = null;
            if (data.get((Object)"startTime") != null) {
                time = data.getLong("startTime");
                startTime = LocalDateTimeUtil.longToLocalTime((Long)time);
                data.remove((Object)"startTime");
            }
            if (data.get((Object)"lastUploadTime") != null) {
                time = data.getLong("lastUploadTime");
                lastUploadTime = LocalDateTimeUtil.longToLocalTime((Long)time);
                data.remove((Object)"lastUploadTime");
            }
            try {
                if (data.getInteger("Number_1") != null && data.getInteger("Number_2") != null) {
                    Integer number1 = data.getInteger("Number_1");
                    Integer number2 = data.getInteger("Number_2");
                    int abs = Math.abs(number1 - number2);
                    if (abs > 5) {
                        data.put("numberStatus", (Object)"\u538b\u529b\u6570\u636e\u5f02\u5e38");
                    } else {
                        data.put("numberStatus", (Object)"\u538b\u529b\u6570\u636e\u6b63\u5e38");
                    }
                }
            }
            catch (Exception number1) {
                // empty catch block
            }
            BusPumpEntity record = (BusPumpEntity)data.toJavaObject(BusPumpEntity.class);
            if (!this.existHospital(record.getHospitalCode()).booleanValue()) {
                return;
            }
            record.setNumberStatus("\u672a\u4e0a\u4f20\u538b\u529b\u503c");
            if (NumberUtil.isInteger((String)record.getNumber1()) && NumberUtil.isInteger((String)record.getNumber2())) {
                int abs = Math.abs(Integer.valueOf(record.getNumber1()) - Integer.valueOf(record.getNumber2()));
                if (abs > 5) {
                    record.setNumberStatus("\u538b\u529b\u6570\u636e\u5f02\u5e38");
                } else {
                    record.setNumberStatus("\u538b\u529b\u6570\u636e\u6b63\u5e38");
                }
            }
            record.setStartTime(startTime);
            record.setLastUploadTime(lastUploadTime);
            record.setIsFamily(false);
            if (data.containsKey((Object)"number8")) {
                this.iBusPumpService.pumpRabbitCopyHandle(record);
            } else {
                this.iBusPumpService.pumpRabbitHandle(record);
                this.pushInfo.pushErrorInfo(record.getStateFlag(), record.getBufState9(), record.getPumpCode(), record.getProductCode());
            }
        }
        catch (Exception e) {
            log.error("======" + e.getMessage() + "======");
        }
    }

    @RabbitListener(queuesToDeclare={@Queue(value="cloud.analgesicScore")})
    public void analgesicScoreHandle(byte[] bytes) {
        BusAnalgesicScoreEntity record;
        String message = RabbitHandle.byteToString(bytes);
        log.info("======analgesicScoreHandle======:" + message);
        JSONObject data = JSONObject.parseObject((String)message);
        LocalDateTime followDate = null;
        if (data.get((Object)"followDate") != null) {
            long time = data.getLong("followDate");
            followDate = LocalDateTimeUtil.longToLocalTime((Long)time);
            data.remove((Object)"followDate");
        }
        if (!this.existHospital((record = (BusAnalgesicScoreEntity)data.toJavaObject(BusAnalgesicScoreEntity.class)).getHospitalCode()).booleanValue()) {
            return;
        }
        record.setFollowDate(followDate);
        CommonResult<Object> result = this.iBusAnalgesicScoreService.analgesicScoreRabbitHandle(record);
        if (ResultCode.SUCCESS.getCode() != result.getCode()) {
            log.info("======" + result.getMessage() + "======");
        }
    }

    @RabbitListener(queuesToDeclare={@Queue(value="cloud.config")})
    public void configHandle(byte[] bytes) {
        String message = RabbitHandle.byteToString(bytes);
        log.info("======configHandle======:" + message);
        SysConfigEntity record = (SysConfigEntity)JSONObject.parseObject((String)message, SysConfigEntity.class);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"hospital_code", (Object)record.getHospitalCode());
        wrapper.eq((Object)"name", (Object)record.getName());
        SysConfigEntity one = (SysConfigEntity)this.iSysConfigService.getOne((Wrapper)wrapper);
        if (one == null) {
            this.iSysConfigService.save(record);
        } else {
            record.setId(one.getId());
            this.iSysConfigService.updateById(record);
        }
    }

    @RabbitListener(queues={"phoneAnalgesicScoreQueue"})
    public void pumpHandle(JSON message) {
        log.info("======phoneAnalgesicScoreQueueHandle======:" + message);
        System.out.println(message);
    }

    private Boolean existHospital(String hospital) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"hospital_code", (Object)hospital);
        BusHospitalEntity one = (BusHospitalEntity)this.iBusHospitalService.getOne((Wrapper)wrapper);
        if (one == null) {
            return false;
        }
        return true;
    }

    public static String byteToString(byte[] bytes) {
        String message = "";
        try {
            message = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u8f6c\u5316UTF-8\u5b57\u7b26\u4e32\u5f02\u5e38", (Throwable)e);
        }
        return message;
    }

    public void sendRemovePump(Map<String, List<BusPumpEntity>> removePumpMap) {
        removePumpMap.forEach((k, v) -> this.rabbitTemplate.convertAndSend("removePump", k, (Object)JSONUtil.toJsonStr(v.stream().map(BusPumpEntity::getPumpCode).collect(Collectors.toList()))));
    }

    public RabbitHandle(RabbitTemplate rabbitTemplate, ISysBreathService iSysBreathService, IBusHospitalService iBusHospitalService, IBusPatientService iBusPatientService, IBusPumpService iBusPumpService, IBusAnalgesicScoreService iBusAnalgesicScoreService, ISysConfigService iSysConfigService, PushInfo pushInfo) {
        this.rabbitTemplate = rabbitTemplate;
        this.iSysBreathService = iSysBreathService;
        this.iBusHospitalService = iBusHospitalService;
        this.iBusPatientService = iBusPatientService;
        this.iBusPumpService = iBusPumpService;
        this.iBusAnalgesicScoreService = iBusAnalgesicScoreService;
        this.iSysConfigService = iSysConfigService;
        this.pushInfo = pushInfo;
    }
}

